% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.R
\name{spectral_density}
\alias{spectral_density}
\title{Estimate the spectral density of data points}
\usage{
spectral_density(view, columns = NULL, data_points = NULL, ...)
}
\arguments{
\item{view}{\code{ProcessedView} or \code{FilteredView} object.}

\item{columns}{names of data columns e.g. Nose_x.}

\item{data_points}{data points to process e.g. Nose.}

\item{...}{passed to \code{\link[stats:spectrum]{stats::spectrum()}}.}
}
\value{
\code{SpectralDensityView} object.
}
\description{
Estimates the periodicity of data points in a \code{View} object.
}
\examples{
r<-get_recording("NIR_ABh_Puriya", fps=25)
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
sd1 <- spectral_density(pv, columns = "LEar_x", spans = 5)

fv <- apply_filter_sgolay(pv, data_points = c("LEye"), n = 19, p = 4)
sd1 <- spectral_density(fv, data_points = c("LEye"), spans = 5)
}
