% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motion.R
\name{motion_gram}
\alias{motion_gram}
\title{Motion gram of a view object}
\usage{
motion_gram(obj, maxpts = 10000, alpha = 0.5, ...)
}
\arguments{
\item{obj}{view object}

\item{maxpts}{maximum number of points to plot.}

\item{alpha}{ggplot aesthetic value.}

\item{...}{passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}},}
}
\value{
a \code{gtable} object.
}
\description{
Motion gram of a view object
}
\examples{
r1 <- get_sample_recording()
rv1 <- get_raw_view(r1, "Central", "", "Sitar")
pv1 <- get_processed_view(rv1)
dp <- c("LWrist", "RWrist", "LElbow", "RElbow", "LEye", "REye", "MidHip")
fv1 <- apply_filter_sgolay(pv1, data_point = dp, n = 41, p = 4)
sub_fv1 <- subset(fv1, Time >= 0 & Time <= 20, dp, by = 2)
motion_gram(sub_fv1)
}
