% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbo_defaults.R
\name{default_gp}
\alias{default_gp}
\title{Default Gaussian Process}
\usage{
default_gp(noisy = FALSE)
}
\arguments{
\item{noisy}{(logical(1))\cr
Whether the learner will be used in a noisy objective function scenario.
See above.}
}
\value{
\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}
}
\description{
This is a helper function that constructs a default Gaussian Process \link[mlr3:LearnerRegr]{mlr3::LearnerRegr} which is for example used in
\link{default_surrogate}.

Constructs a Kriging learner \dQuote{"regr.km"} with kernel \dQuote{"matern5_2"}.
If \code{noisy = FALSE} (default) a small nugget effect is added \code{nugget.stability = 10^-8} to increase
numerical stability to hopefully prevent crashes of \CRANpkg{DiceKriging}.
If \code{noisy = TRUE} the nugget effect will be estimated with \code{nugget.estim = TRUE}.
If \code{noisy = TRUE} \code{jitter} is set to \code{TRUE} to circumvent a problem with \CRANpkg{DiceKriging} where
already trained input values produce the exact trained output.
In general, instead of the default \code{"BFGS"} optimization method we use rgenoud (\code{"gen"}), which is a hybrid
algorithm, to combine global search based on genetic algorithms and local search based on gradients.
This may improve the model fit and will less frequently produce a constant model prediction.
}
\seealso{
Other mbo_defaults: 
\code{\link{default_acqfunction}()},
\code{\link{default_acqoptimizer}()},
\code{\link{default_loop_function}()},
\code{\link{default_result_assigner}()},
\code{\link{default_rf}()},
\code{\link{default_surrogate}()},
\code{\link{mbo_defaults}}
}
\concept{mbo_defaults}
