% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaaGenerics.R, R/objectPkModel.R
\docType{methods}
\name{plotObject}
\alias{plotObject}
\alias{plotObject,PkModel-method}
\alias{plotObject,PkData-method}
\title{generic function to plot an object}
\usage{
plotObject(object, ...)

\S4method{plotObject}{PkModel}(object, times, nCurves = 12,
  nSamplesIntegration = 1000, seed = 134, sampleCurvesOnly = FALSE,
  indSamplingPoints = FALSE)

\S4method{plotObject}{PkData}(object, nCurves = NULL,
  nSamplesIntegration = 1000, sampleCurvesOnly = TRUE, seed = NULL,
  indSamplingPoints = TRUE, addZeroIsZero = FALSE)
}
\arguments{
\item{object}{a S4 class object}

\item{...}{additional parameters}

\item{times}{numeric vector at of times at which the model should be simulated for \code{\link{PkModel-class}}}

\item{nCurves}{the number of sample curves defaults to 12 for \code{\link{PkModel-class}} ,
if \code{\link{PkData-class}} defaults to \code{NULL} meaning all data are plotted}

\item{nSamplesIntegration}{number of simulated curves to calculate averaged curve, defaults to  1000}

\item{seed}{specify the random seed to draw samples to get the same plot each time}

\item{sampleCurvesOnly}{logical value if \code{TRUE} only sample curves are displayed and the averaged curve omitted ,
defaults to \code{FALSE} for \code{\link{PkModel-class}} and \code{TRUE} for \code{\link{PkData-class}}}

\item{indSamplingPoints}{logical indicator if \code{TRUE} sample times are indicated on the plot, 
defaults to \code{FALSE} for \code{\link{PkModel-class}} and \code{TRUE} for \code{\link{PkData-class}}}

\item{addZeroIsZero}{logical value, when \code{TRUE} the zero point is added 
to the plot with value zero ( only for  \code{\link{PkData-class}} , defaults to \code{FALSE} )}
}
\description{
generic function to plot an object
}
\examples{
\dontrun{
# examples with limited number of samples, increase samples in practice
plotObject( object =  getExamplePkModel() , 
   times = seq( 0 , 10 , 1 )  , nSamplesIntegration = 25 )
plotObject( object =  getExamplePkModel() ,
   times = seq( 0 , 10 , 1 ) , nCurves = 3 , nSamplesIntegration = 5  )
plotObject( object =  getExamplePkModel() ,
    times = seq( 0 , 10 , 1 ) , nCurves = 3 , sampleCurvesOnly = TRUE  )
}
\dontrun{
pkData    <-   getPkData( getExamplePkModel() , 1:10 ,  5 , 10 )
plotObject( object =  pkData  )
plotObject( object =  pkData , nCurves = 2 )
plotObject( object =  pkData , nCurves = 2 , addZeroIsZero = TRUE )
plotObject( object = pkData , nCurves = 3 , 
   sampleCurvesOnly = FALSE , nSamplesIntegration = 25   ) 
} 
}
