% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{toy_metaboscape}
\alias{toy_metaboscape}
\title{A small toy data set created from a feature table in MetaboScape style}
\format{
\subsection{\code{toy_metaboscape}}{

A data frame with 110 rows and 8 columns:
\describe{
\item{UID}{A unique identifier for each Feature. This column is automatically generated by \code{metamorphr::read_featuretable()} when the feature table is imported.}
\item{Feature}{A label given to each Feature for easier identification. The column of the original feature table that is used to generate the Feature column is specified with the \code{label_col} argument of \code{metamorphr::read_featuretable()}.}
\item{Sample}{Sample name. Column names in the original feature table.}
\item{Intensity}{Measured intensity (or area).}
\item{RT}{Retention time. Feature metadata and therefore not really necessary.}
\item{m/z}{Mass over charge. Feature metadata and therefore not really necessary.}
\item{Name}{Feature name. Feature metadata and therefore not really necessary.}
\item{Formula}{Chemical formula. Feature metadata and therefore not really necessary.}
...
}
}
}
\source{
This data set contains fictional data!
}
\usage{
toy_metaboscape
}
\description{
The raw feature table is also included.
This tibble can be reproduced with \code{metamorphr::read_featuretable(system.file("extdata", "toy_metaboscape.csv", package = "metamorphr"), metadata_cols = 2:5)}.
}
\keyword{datasets}
