% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_mgf}
\alias{read_mgf}
\title{Read a MGF file into a tidy tibble}
\usage{
read_mgf(file, show_progress = TRUE)
}
\arguments{
\item{file}{The path to the MGF file.}

\item{show_progress}{A \code{logical} indicating whether the progress of the import should be printed to the console. Only important for large MGF files.}
}
\value{
A tidy tibble holding MS/MS spectra.
}
\description{
\href{https://www.matrixscience.com/help/data_file_help.html}{MGF files} allow the storage of MS/MS spectra. With this
function they can be read into a tidy tibble. Each variable is stored in a column and each ion (observation) is stored in a separate row.
MS/MS spectra are stored in a list column named MSn. \if{html}{\out{<br>}}
Please note that \href{https://fiehnlab.ucdavis.edu/projects/lipidblast/mgf-files}{MGF files are software-specific} so the variables
and their names may vary. This function was developed with the GNPS file format exported from \href{https://mzio.io/mzmine-news/}{mzmine} in mind.
}
\examples{
mgf_path <- system.file("extdata", "toy_mgf.mgf", package = "metamorphr")
read_mgf(mgf_path)
}
