% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputes.R
\name{impute_lls}
\alias{impute_lls}
\title{Impute missing values using Local Least Squares (LLS)}
\usage{
impute_lls(
  data,
  correlation = "pearson",
  complete_genes = FALSE,
  center = FALSE,
  cluster_size = 10
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{correlation}{The method used to calculate correlations between features. One of \code{"pearson"}, \code{"spearman"} or \code{"kendall"}. See \code{\link[stats]{cor}}.}

\item{complete_genes}{If \code{TRUE} only complete features will be used for regression, if \code{FALSE}, all will be used.}

\item{center}{Should \code{data} be mean centered? See \code{\link[pcaMethods]{prep}} for details.}

\item{cluster_size}{The number of similar features used for regression.}
}
\value{
A tibble with imputed missing values.
}
\description{
Basically a wrapper around \verb{pcaMethods::}\code{\link[pcaMethods]{llsImpute}}.
For a detailed discussion, see the \code{vignette("pcaMethods")} and \code{vignette("missingValues", "pcaMethods")} as well as the References section.

\emph{Important Note}
\code{impute_lls()} depends on the \code{pcaMethods} package from Bioconductor. If \code{metamorphr} was installed via \code{install.packages()}, dependencies from Bioconductor were not
automatically installed. When \code{impute_svd()} is called without the \code{pcaMethods} package installed, you should be asked if you want to install \code{pak} and \code{pcaMethods}.
If you want to use \code{impute_lls()} you have to install those. In case you run into trouble with the automatic installation, please install \code{pcaMethods} manually. See
\href{https://www.bioconductor.org/packages/release/bioc/html/pcaMethods.html}{pcaMethods – a Bioconductor package providing PCA methods for incomplete data} for instructions on manual installation.
}
\examples{
# The cluster size must be reduced because
# the data set is too small for the default (10)

toy_metaboscape \%>\%
  impute_lls(complete_genes = TRUE, cluster_size = 5)
}
\references{
\itemize{
\item H. R. Wolfram Stacklies, \strong{2017}, DOI 10.18129/B9.BIOC.PCAMETHODS.
\item W. Stacklies, H. Redestig, M. Scholz, D. Walther, J. Selbig, \emph{Bioinformatics} \strong{2007}, \emph{23}, 1164–1167, DOI 10.1093/bioinformatics/btm069.
}
}
