% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputes.R
\name{impute_knn}
\alias{impute_knn}
\title{Impute missing values using nearest neighbor averaging}
\usage{
impute_knn(data, quietly = TRUE, ...)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{quietly}{\code{TRUE} or \code{FALSE}. Should messages and warnings from \code{\link[impute]{impute.knn}} be printed to the console?}

\item{...}{Additional parameters passed to \code{\link[impute]{impute.knn}}.}
}
\value{
A tibble with imputed missing values.
}
\description{
Basically a wrapper function around \verb{impute::}\code{\link[impute]{impute.knn}}. Imputes missing values using the k-th nearest neighbor algorithm.

Note that the function ln-transforms the data prior to imputation and transforms it back to the original scale afterwards. \strong{Please do not do it manually prior to calling \code{impute_knn()}!}
See References for more information.

\strong{Important Note}

\code{impute_knn()} depends on the \code{impute} package from Bioconductor. If \code{metamorphr} was installed via \code{install.packages()}, dependencies from Bioconductor were not
automatically installed. When \code{impute_knn()} is called without the \code{impute} package installed, you should be asked if you want to install \code{pak} and \code{impute}.
If you want to use \code{impute_knn()} you have to install those. In case you run into trouble with the automatic installation, please install \code{impute} manually. See
\href{https://bioconductor.org/packages/release/bioc/html/impute.html}{impute: Imputation for microarray data} for instructions on manual installation.
}
\examples{
toy_metaboscape \%>\%
  impute_knn()
}
\references{
\itemize{
\item Robert Tibshirani, Trevor Hastie, \strong{2017}, DOI 10.18129/B9.BIOC.IMPUTE.
\item J. Khan, J. S. Wei, M. Ringnér, L. H. Saal, M. Ladanyi, F. Westermann, F. Berthold, M. Schwab, C. R. Antonescu, C. Peterson, P. S. Meltzer, \emph{Nat Med} \strong{2001}, \emph{7}, 673–679, DOI 10.1038/89044.
}
}
