% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.longarm.R
\name{subset.longarm}
\alias{subset.longarm}
\title{Return subset of longarm object}
\usage{
\method{subset}{longarm}(x, subset, ...)
}
\arguments{
\item{x}{An object of class \code{longarm}.}

\item{subset}{A logical expression indicating elements or rows to
keep: missing values are taken as false.}

\item{\dots}{Additional arguments.}
}
\value{
A \code{\link{longarm}} object is returned.
}
\description{
The \code{subset} method returns a subset of a longarm object.
}
\examples{
# Transform data from wide arm-based format to contrast-based format
pw1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
  n = list(n1, n2, n3),
  mean = list(y1, y2, y3), sd = list(sd1, sd2, sd3),
  data = dat.franchini2012, studlab = Study)

# Transform data from contrast-based to long arm-based format
# and only keep the main variables
la1 <- longarm(pw1, append = FALSE)
head(la1)

# Subset without Lieberman studies
subset(la1, grepl("Lieberman", studlab))

}
\seealso{
\code{\link{longarm}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
