% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{legend_style}
\alias{legend_style}
\title{Create custom styling for map legends}
\usage{
legend_style(
  background_color = NULL,
  background_opacity = NULL,
  border_color = NULL,
  border_width = NULL,
  border_radius = NULL,
  text_color = NULL,
  text_size = NULL,
  title_color = NULL,
  title_size = NULL,
  font_family = NULL,
  title_font_family = NULL,
  font_weight = NULL,
  title_font_weight = NULL,
  element_border_color = NULL,
  element_border_width = NULL,
  shadow = NULL,
  shadow_color = NULL,
  shadow_size = NULL,
  padding = NULL
)
}
\arguments{
\item{background_color}{Background color for the legend container (e.g., "white", "#ffffff").}

\item{background_opacity}{Opacity of the legend background (0-1, where 1 is fully opaque).}

\item{border_color}{Color of the legend border (e.g., "black", "#000000").}

\item{border_width}{Width of the legend border in pixels.}

\item{border_radius}{Border radius for rounded corners in pixels.}

\item{text_color}{Color of the legend text (e.g., "black", "#000000").}

\item{text_size}{Size of the legend text in pixels.}

\item{title_color}{Color of the legend title text.}

\item{title_size}{Size of the legend title text in pixels.}

\item{font_family}{Font family for legend text (e.g., "Arial", "Times New Roman", "Open Sans").}

\item{title_font_family}{Font family for legend title (defaults to font_family if not specified).}

\item{font_weight}{Font weight for legend text (e.g., "normal", "bold", "lighter", or numeric like 400, 700).}

\item{title_font_weight}{Font weight for legend title (defaults to font_weight if not specified).}

\item{element_border_color}{Color for borders around legend elements (color bar for continuous, patches/circles for categorical).}

\item{element_border_width}{Width in pixels for borders around legend elements.}

\item{shadow}{Logical, whether to add a drop shadow to the legend.}

\item{shadow_color}{Color of the drop shadow (e.g., "black", "rgba(0,0,0,0.3)").}

\item{shadow_size}{Size/blur radius of the drop shadow in pixels.}

\item{padding}{Internal padding of the legend container in pixels.}
}
\value{
A list of class "mapgl_legend_style" containing the styling options.
}
\description{
This function creates a styling object that can be passed to legend functions
to customize the appearance of legends, including colors, fonts, borders, and shadows.
}
\examples{
\dontrun{
# Create a dark theme legend style
dark_style <- legend_style(
  background_color = "#2c3e50",
  text_color = "white",
  title_color = "white",
  font_family = "Arial",
  title_font_weight = "bold",
  element_border_color = "white",
  element_border_width = 1,
  shadow = TRUE,
  shadow_color = "rgba(0,0,0,0.3)",
  shadow_size = 6
)

# Use the style in a legend
add_categorical_legend(
  map = map,
  legend_title = "Categories",
  values = c("A", "B", "C"),
  colors = c("red", "green", "blue"),
  style = dark_style
)

# Create a minimal style with just borders
minimal_style <- legend_style(
  element_border_color = "gray",
  element_border_width = 1
)
}
}
