% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_indirect_list.R
\name{print.indirect_list}
\alias{print.indirect_list}
\title{Print an 'indirect_list' Class
Object}
\usage{
\method{print}{indirect_list}(
  x,
  digits = 3,
  annotation = TRUE,
  pvalue = FALSE,
  pvalue_digits = 3,
  se = FALSE,
  for_each_path = FALSE,
  ...
)
}
\arguments{
\item{x}{The output of
\code{\link[=many_indirect_effects]{many_indirect_effects()}}.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{annotation}{Logical. Whether
the annotation after the table of
effects is to be printed. Default is
\code{TRUE.}}

\item{pvalue}{Logical. If \code{TRUE},
asymmetric \emph{p}-values based on
bootstrapping will be printed if
available.}

\item{pvalue_digits}{Number of decimal
places to display for the \emph{p}-values.
Default is 3.}

\item{se}{Logical. If \code{TRUE} and
confidence intervals are available,
the standard errors of the estimates
are also printed. They are simply the
standard deviations of the bootstrap
estimates or Monte Carlo simulated
values, depending on the method used
to form the confidence intervals.}

\item{for_each_path}{Logical. If
\code{TRUE}, each of the paths will be
printed individually, using the
\code{print}-method of the output of
\code{\link[=indirect_effect]{indirect_effect()}}. Default is
\code{FALSE}.}

\item{...}{Other arguments. If
\code{for_each_path} is \code{TRUE}, they
will be passed to the print method
of the output of \code{\link[=indirect_effect]{indirect_effect()}}.
Ignored otherwise.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=many_indirect_effects]{many_indirect_effects()}}.
}
\details{
The \code{print} method of the
\code{indirect_list}-class object.

If bootstrapping confidence interval
was requested, this method has the
option to print a
\emph{p}-value computed by the
method presented in Asparouhov and Muthén (2021).
Note that this \emph{p}-value is asymmetric
bootstrap \emph{p}-value based on the
distribution of the bootstrap estimates.
It is not computed based on the
distribution under the null hypothesis.

For a \emph{p}-value of \emph{a}, it means that
a 100(1 - \emph{a})\% bootstrapping confidence
interval
will have one of its limits equal to
0. A confidence interval
with a higher confidence level will
include zero, while a confidence
interval with a lower confidence level
will exclude zero.
}
\examples{

library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)
# All indirect paths from x to y
paths <- all_indirect_paths(fit,
                           x = "x",
                           y = "y")
paths
# Indirect effect estimates
out <- many_indirect_effects(paths,
                             fit = fit)
out


}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=many_indirect_effects]{many_indirect_effects()}}
}
