% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal.R
\name{marginal_plink}
\alias{marginal_plink}
\title{Marginal (SQ/CP) approach}
\usage{
marginal_plink(y, file, adjustment = NULL, pop_struct = NULL, verbose = TRUE)
}
\arguments{
\item{y}{matrix of traits (n observations by k traits)}

\item{file}{path to plink files}

\item{adjustment}{matrix of covariates to adjust traits}

\item{pop_struct}{matrix of PCs that captures population structure}

\item{verbose}{If TRUE (default) print progress.}
}
\value{
A data frame of p-values where the columns are the cross products/squared residuals
and the rows are SNPs.
}
\description{
The \code{marginal_plink} function performs a trait-by-trait univariate test for latent interactions
using the squared residuals and cross products. This function is suitable for large
datasets (e.g., UK Biobank) in plink format. Note that our code to process plink files builds from the
\code{\link{genio}} R package.
}
\examples{
# set seed
set.seed(123)

# Path to plink files
file <- system.file("extdata", 'sample.bed', package = "genio", mustWork = TRUE)

# Generate trait expression
Y <- matrix(rnorm(10*4), ncol = 4)

out <- marginal_plink(Y, file = file)

}
\seealso{
\code{\link{marginal_plink}}
}
