% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo_digital_surface_model.r
\name{dsmtin}
\alias{dsmtin}
\title{Digital Surface Model Algorithm}
\usage{
dsmtin(max_edge = 0)
}
\arguments{
\item{max_edge}{numeric. Maximum edge length of a triangle in the Delaunay triangulation.
If a triangle has an edge length greater than this value it will be removed to trim dummy interpolation
on non-convex areas. If \code{max_edge = 0} no trimming is done (see examples).}
}
\description{
This function is made to be used in \link{grid_canopy}. It implements an algorithm for digital
surface model computation using a Delaunay triangulation of first returns with a linear interpolation
within each triangle.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)
col <- height.colors(50)

# Basic triangulation and rasterization of first returns
chm <- grid_canopy(las, res = 1, dsmtin())
plot(chm, col = col)

\dontrun{
# Potentially complex concave subset of point cloud
x = c(481340, 481340, 481280, 481300, 481280, 481340)
y = c(3812940, 3813000, 3813000, 3812960, 3812940, 3812940)
las2 = lasclipPolygon(las,x,y)
plot(las2)

# Since the TIN interpolation is done within the convex hull of the point cloud
# dummy pixels are interpolated that are strictly correct according to the interpolation method
# used, but meaningless in our CHM
chm <- grid_canopy(las2, res = 0.5, dsmtin())
plot(chm, col = col)

# Use 'max_edge' to trim dummy triangles
chm = grid_canopy(las2, res = 0.5, dsmtin(max_edge = 3))
plot(chm, col = col)
}
}
\seealso{
Other digital surface model algorithms: \code{\link{p2r}},
  \code{\link{pitfree}}
}
\concept{digital surface model algorithms}
