% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-recurrent-cells.R
\name{layer_gru_cell}
\alias{layer_gru_cell}
\title{Cell class for the GRU layer}
\usage{
layer_gru_cell(
  units,
  activation = "tanh",
  recurrent_activation = "sigmoid",
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  dropout = 0,
  recurrent_dropout = 0,
  reset_after = TRUE,
  ...
)
}
\arguments{
\item{units}{Positive integer, dimensionality of the output space.}

\item{activation}{Activation function to use. Default: hyperbolic tangent
(\code{tanh}). If you pass \code{NULL}, no activation is applied
(ie. "linear" activation: \code{a(x) = x}).}

\item{recurrent_activation}{Activation function to use for the recurrent step.
Default: sigmoid (\code{sigmoid}). If you pass \code{NULL}, no activation is
applied (ie. "linear" activation: \code{a(x) = x}).}

\item{use_bias}{Boolean, (default \code{TRUE}), whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix,
used for the linear transformation of the inputs. Default:
\code{glorot_uniform}.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel}
weights matrix, used for the linear transformation of the recurrent state.
Default: \code{orthogonal}.}

\item{bias_initializer}{Initializer for the bias vector. Default: \code{zeros}.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel} weights
matrix. Default: \code{NULL}.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix. Default: \code{NULL}.}

\item{bias_regularizer}{Regularizer function applied to the bias vector. Default:
\code{NULL}.}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix. Default: \code{NULL}.}

\item{recurrent_constraint}{Constraint function applied to the \code{recurrent_kernel}
weights matrix. Default: \code{NULL}.}

\item{bias_constraint}{Constraint function applied to the bias vector. Default:
\code{NULL}.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
linear transformation of the inputs. Default: 0.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop for
the linear transformation of the recurrent state. Default: 0.}

\item{reset_after}{GRU convention (whether to apply reset gate after or
before matrix multiplication). FALSE = "before",
TRUE = "after" (default and CuDNN compatible).}

\item{...}{standard layer arguments.}
}
\description{
Cell class for the GRU layer
}
\details{
See \href{https://www.tensorflow.org/guide/keras/rnn}{the Keras RNN API guide}
for details about the usage of RNN API.

This class processes one step within the whole time sequence input, whereas
\code{tf.keras.layer.GRU} processes the whole sequence.

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{inputs <- k_random_uniform(c(32, 10, 8))
output <- inputs \%>\% layer_rnn(layer_gru_cell(4))
output$shape  # TensorShape([32, 4])

rnn <- layer_rnn(cell = layer_gru_cell(4),
                 return_sequence = TRUE,
                 return_state = TRUE)
c(whole_sequence_output, final_state) \%<-\% rnn(inputs)
whole_sequence_output$shape # TensorShape([32, 10, 4])
final_state$shape           # TensorShape([32, 4])
}\if{html}{\out{</div>}}
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/GRUCell}
}

Other RNN cell layers: 
\code{\link{layer_lstm_cell}()},
\code{\link{layer_simple_rnn_cell}()},
\code{\link{layer_stacked_rnn_cells}()}
}
\concept{RNN cell layers}
