% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_discretization}
\alias{layer_discretization}
\title{A preprocessing layer which buckets continuous features by ranges.}
\usage{
layer_discretization(
  object,
  bin_boundaries = NULL,
  num_bins = NULL,
  epsilon = 0.01,
  output_mode = "int",
  sparse = FALSE,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{bin_boundaries}{A list of bin boundaries. The leftmost and rightmost bins
will always extend to \code{-Inf} and \code{Inf}, so \code{bin_boundaries = c(0., 1., 2.)}
generates bins \verb{(-Inf, 0.)}, \verb{[0., 1.)}, \verb{[1., 2.)}, and \verb{[2., +Inf)}. If
this option is set, \code{adapt} should not be called.}

\item{num_bins}{The integer number of bins to compute. If this option is set,
\code{adapt} should be called to learn the bin boundaries.}

\item{epsilon}{Error tolerance, typically a small fraction close to zero (e.g.
0.01). Higher values of epsilon increase the quantile approximation, and
hence result in more unequal buckets, but could improve performance
and resource consumption.}

\item{output_mode}{Specification for the output of the layer. Defaults to
\code{"int"}.  Values can be \code{"int"}, \code{"one_hot"}, \code{"multi_hot"}, or
\code{"count"} configuring the layer as follows:
\itemize{
\item \code{"int"}: Return the discretized bin indices directly.
\item \code{"one_hot"}: Encodes each individual element in the input into an
array the same size as \code{num_bins}, containing a 1 at the input's bin
index. If the last dimension is size 1, will encode on that
dimension.  If the last dimension is not size 1, will append a new
dimension for the encoded output.
\item \code{"multi_hot"}: Encodes each sample in the input into a single array
the same size as \code{num_bins}, containing a 1 for each bin index
index present in the sample. Treats the last dimension as the sample
dimension, if input shape is \verb{(..., sample_length)}, output shape
will be \verb{(..., num_tokens)}.
\item \code{"count"}: As \code{"multi_hot"}, but the int array contains a count of
the number of times the bin index appeared in the sample.
}}

\item{sparse}{Boolean. Only applicable to \code{"one_hot"}, \code{"multi_hot"},
and \code{"count"} output modes. If \code{TRUE}, returns a \code{SparseTensor} instead of
a dense \code{Tensor}. Defaults to \code{FALSE}.}

\item{...}{standard layer arguments.}
}
\description{
A preprocessing layer which buckets continuous features by ranges.
}
\details{
This layer will place each element of its input data into one of several
contiguous ranges and output an integer index indicating which range each
element was placed in.

Input shape:
Any \code{tf.Tensor} or \code{tf.RaggedTensor} of dimension 2 or higher.

Output shape:
Same as input shape.
}
\seealso{
\itemize{
\item \code{\link[=adapt]{adapt()}}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Discretization}
\item \url{https://keras.io/api/layers/preprocessing_layers/numerical/discretization}
}

Other numerical features preprocessing layers: 
\code{\link{layer_normalization}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_brightness}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{numerical features preprocessing layers}
\concept{preprocessing layers}
