% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/johnson_neyman.R
\name{johnson_neyman}
\alias{johnson_neyman}
\title{Calculate Johnson-Neyman intervals for 2-way interactions}
\usage{
johnson_neyman(model, pred, modx, vmat = NULL, alpha = 0.05, plot = TRUE)
}
\arguments{
\item{model}{A regression model of type \code{lm} or \code{\link[survey]{svyglm}}.
It should contain the interaction of interest.}

\item{pred}{The predictor variable involved in the interaction.}

\item{modx}{The moderator variable involved in the interaction.}

\item{vmat}{Optional. You may supply the variance-covariance matrix of the
coefficients yourself. This is useful if you are using robust standard
errors, as you could if using the \pkg{sandwich} package.}

\item{alpha}{The alpha level. By default, the standard 0.05.}

\item{plot}{Should a plot of the results be printed? Default is \code{TRUE}.
The \code{ggplot2} object is returned either way.}
}
\value{
\item{bounds}{The two numbers that make up the interval.}
 \item{cbands}{A dataframe with predicted values of the predictor's slope
   and lower/upper bounds of confidence bands if you would like to make your
   own plots}
 \item{plot}{The \code{ggplot} object used for plotting. You can tweak the
   plot like you could any other from \code{ggplot}.}
}
\description{
\code{johnson_neyman} finds so-called "Johnson-Neyman" intervals for
understanding where simple slopes are significant in the context of
interactions in multiple linear regression.
}
\details{
The interpretation of the values given by this function is important and not
 always immediately intuitive. For an interaction between a predictor variable
 and moderator variable, it is often the case that the slope of the predictor
 is statistically significant at only some values of the moderator. For
 example, perhaps the effect of your predictor is only significant when the
 moderator is set at some high value.

 The Johnson-Neyman interval provides the two values of the moderator at
 which the slope of the predictor goes from non-significant to significant.
 Usually, the predictor's slope is only significant \emph{outside} of the
 range given by the function. The output of this function will make it clear
 either way.

 This technique is not easily ported to 3-way interaction contexts. You could,
 however, look at the J-N interval at two different levels of a second
 moderator. This does forego a benefit of the J-N technique, which is not
 having to pick arbitrary points. If you want to do this, just use the
 \code{\link{sim_slopes}} function's ability to handle 3-way interactions
 and request Johnson-Neyman intervals for each.
}
\examples{
# Using a fitted lm model
states <- as.data.frame(state.x77)
states$HSGrad <- states$`HS Grad`
fit <- lm(Income ~ HSGrad + Murder*Illiteracy,
  data = states)
johnson_neyman(model = fit, pred = Murder,
  modx = Illiteracy)

}
\references{
Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and multilevel
 regression: Inferential and graphical techniques. \emph{Multivariate Behavioral
 Research}, \emph{40}(3), 373-400.
 \url{http://dx.doi.org/10.1207/s15327906mbr4003_5}

Johnson, P.O. & Fay, L.C. (1950). The Johnson-Neyman technique, its theory
 and application. \emph{Psychometrika}, \emph{15}, 349-367.
 \url{http://dx.doi.org/10.1007/BF02288864}
}
\seealso{
Other interaction tools: \code{\link{interact_plot}},
  \code{\link{probe_interaction}}, \code{\link{sim_slopes}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
