% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space.R
\name{space}
\alias{space}
\title{Examine the space of incidence matrices with fixed marginals}
\usage{
space(R, C)
}
\arguments{
\item{R}{vector of row sums}

\item{C}{vector of column sums}
}
\value{
a list containing (a) a list of all matrices in the space and (b) a matrix of their perturbations
}
\description{
Examine the space of incidence matrices with fixed marginals
}
\details{
This implementation \emph{attempts} to ennumerate all matrices in the space, but a complete ennumeration is
not guaranteed. The cardinality of the space is often unknown and can be quite large. Therefore, exercise
caution when examining the space of matrices larger than 5x5.
}
\examples{
space(R = c(2,1,1), C = c(1,1,2))
}
