% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSummaryStatisticsTable.R
\name{getSummaryStatisticsTable}
\alias{getSummaryStatisticsTable}
\title{Get summary statistics table}
\usage{
getSummaryStatisticsTable(
  data,
  var = NULL,
  varFlag = NULL,
  varLab = NULL,
  varLabInclude = length(var) > 1,
  varInclude0 = FALSE,
  varIgnore = NULL,
  varGeneralLab = "Variable",
  varSubgroupLab = "Variable group",
  varIncludeTotal = FALSE,
  varTotalInclude = FALSE,
  varTotalInSepRow = FALSE,
  rowVar = NULL,
  rowVarLab = NULL,
  rowVarDataLevels = NULL,
  rowOrder = "auto",
  rowOrderTotalFilterFct = NULL,
  rowOrderCatLast = NULL,
  rowVarInSepCol = NULL,
  rowVarFormat = NULL,
  rowVarTotalInclude = NULL,
  rowVarTotalByVar = NULL,
  rowVarTotalInSepRow = NULL,
  rowTotalLab = NULL,
  rowInclude0 = FALSE,
  rowAutoMerge = TRUE,
  emptyValue = "-",
  rowVarTotalPerc = NULL,
  colVar = NULL,
  colVarTotal = colVar,
  colVarTotalPerc = colVarTotal,
  colInclude0 = FALSE,
  colVarDataLevels = NULL,
  colTotalInclude = FALSE,
  colTotalLab = "Total",
  stats = NULL,
  statsExtra = NULL,
  statsVarBy = NULL,
  statsPerc = c("statN", "statm"),
  statsGeneralLab = "Statistic",
  statsValueLab = "StatisticValue",
  statsLabInclude = NULL,
  subjectVar = "USUBJID",
  filterFct = NULL,
  dataTotal = NULL,
  dataTotalPerc = dataTotal,
  dataTotalRow = NULL,
  dataTotalCol = NULL,
  type = "auto",
  byVar = NULL,
  byVarLab = NULL,
  checkVarDiffBySubj = "error",
  labelVars = NULL,
  outputType = "flextable",
  statsLayout = ifelse("DT" \%in\% outputType, "col", "row"),
  landscape = (style == "presentation"),
  margin = 1,
  rowPadBase = 14.4,
  title = NULL,
  footer = NULL,
  file = NULL,
  style = "report",
  colorTable = getColorPaletteTable(style = style),
  colHeaderTotalInclude = TRUE,
  colHeaderMerge = TRUE,
  fontsize = switch(style, report = 8, presentation = 10),
  fontname = switch(style, report = "Times", presentation = "Tahoma"),
  vline = "none",
  hline = "auto",
  pageDim = NULL,
  columnsWidth = NULL,
  expandVar = NULL,
  noEscapeVar = NULL,
  barVar = NULL,
  ...
)
}
\arguments{
\item{data}{Data.frame with dataset to consider for the summary table.}

\item{var}{Character vector with variable(s) of \code{data}, 
to compute statistics on.\cr
If NULL (by default), counts by row/column variable(s) are computed.\cr
To also return counts of the \code{rowVar} in case other \code{var}
are specified, you can include: 'all' in the \code{var}.\cr
Missing values, if present, are filtered 
(also for the report of number of subjects/records).}

\item{varFlag}{Character vector, subset of \code{var} with variable(s) 
of type 'flag' (with 'Y', 'N' or '' for empty/non specified value).
Only the counts for records flagged (with 'Y') are retained.}

\item{varLab}{Named character vector with label for each variable 
specified in \code{var}.
By default, extracted from the \code{labelVars}.
if not available, \code{var} is used.}

\item{varLabInclude}{Logical, if TRUE
the name of the summary statistic variable(s) (\code{var})
are included in the table.
This is automatically set to TRUE if more than one variable(s) 
and is specified, and FALSE if only one variable is specified.}

\item{varInclude0}{Logical, should rows with no counts 
for the count \code{var} or \code{varFlag} variable(s)
be included in the table?
Either:
\itemize{
\item{logical of length 1, if TRUE (FALSE by default) 
rows with no count are included for all \code{var}
}
\item{a character vector containing categorical \code{var} 
for which zero counts rows should be included}
}}

\item{varIgnore}{Vector with elements to ignore in the \code{var} variable(s).
The \code{data} records with such elements in \code{var} are \strong{filtered} from the data 
at the start of the workflow.}

\item{varGeneralLab}{String with general label for variable specified in \code{var}.
In case of multiple variable in \code{var}, this will be included in the table header
(see 'rowVarLab' attribute of the output).}

\item{varSubgroupLab}{String with general label for sub-group of
categorical variable(s) for count table, 'Variable group' by default.
This will be included in the final table header (see 'rowVarLab' attribute of the output).}

\item{varIncludeTotal}{This argument is deprecated, please use: 'varTotalInclude' instead.}

\item{varTotalInclude}{Should the total across all categories of \code{var} 
be included for the count table?
Only used for categorical variables (and \code{var} not 'all').
Either:
\itemize{
\item{logical of length 1, if TRUE (FALSE by default) include the total for all categorical \code{var}}
\item{a character vector containing categorical \code{var} for which the total should be included}
}}

\item{varTotalInSepRow}{Logical, should the total per variable be included in
a separated row (by default) or in the row containing the header of the variable?}

\item{rowVar}{Character vector with variable(s)
to be included in the rows.
If multiple variables are specified, the variables should 
be sorted in hierarchical order
(e.g. body system class before adverse event term)
and are nested in the table.}

\item{rowVarLab}{Named character vector with 
label for the \code{rowVar} variable(s).}

\item{rowVarDataLevels}{Data.frame with unique combinations of \code{rowVar}
to be included in columns.
Each column should correspond to \code{colVar} and as factor
if the elements should be ordered in the final table.}

\item{rowOrder}{Specify how the rows should be ordered in the final table, either a:
\itemize{
\item{String among:
\itemize{
\item{'auto' (by default): if the variable is a factor, keep its order, otherwise order alphabetically}
\item{'alphabetical': order alphabetically}
\item{'total': order rows in decreasing order of the total number of subjects
across all columns for this specific category.}
}}
\item{Function with input the summary table and output the ordered elements of the \code{rowVar}}
}
To specify different ordering methods for different \code{rowVar}, specify a list
of such elements, named with the \code{rowVar} variable.
For the table output of \code{\link{computeSummaryStatisticsTable}} (long format),
this order is also reflected in the \strong{\code{levels}} of the row factor variable.}

\item{rowOrderTotalFilterFct}{Function used to filter the data used to order the rows
based on total counts (in case \code{rowOrder} is 'total'),
To order rows based on one specific column category,
e.g. to order based on the counts in the treatment column:
function(x) subset(x, TRTP == "treatmentX")}

\item{rowOrderCatLast}{String with category to be printed in the last 
row of each \code{rowVar} (if any, set to NULL if none).}

\item{rowVarInSepCol}{Character vector with \code{rowVar}
that should be included in separated columns.
By default (NULL), all row variables are nested in the first column 
of the table.\cr
To include the groups within a \code{var} variable in a separated column, 
set: \code{rowVarInSepCol == 'variableGroup'}.}

\item{rowVarFormat}{(flextable output) Named list with special formatting for the \code{rowVar}.
Currently, only possibility is to set the variable elements in bold, with:
list(var1 = "bold").
(Use 'variable' for \code{var} or 'variableGroup' for group within categorical variables.)}

\item{rowVarTotalInclude}{Character vector with \code{rowVar}
for which the total should be reported.\cr
If the higher row variable is specified, the total across all rows
is reported. \cr
For the export, these variable(s) are formatted as factor with 
\strong{'Total' as the first level}.}

\item{rowVarTotalByVar}{Character vector with a row variable
used to categorize the row total.\cr
Note that this is only used if row total(s) is/are requested via \code{rowVarTotalInclude},
and this variable should also be included in \code{rowVar}.
This can be specified also for a specific row variable if the vector is named.\cr
For example: \code{c(ADECOD = "AESEV")} to compute total by severity 
for row adverse event term in a typical adverse event count table 
(by System Organ Class and Adverse Event Term).}

\item{rowVarTotalInSepRow}{Character vector with \code{rowVarTotalInclude}
(not in \code{rowVarInSepCol}) for which the total should be included in a separated row labelled 'Total'.
Otherwise (by default) the total is included in the header row of each category.}

\item{rowTotalLab}{(flextable output) string with label for the row with total.}

\item{rowInclude0}{Logical, if TRUE (FALSE by default),
include rows with no records, based on all combinations 
of the \code{rowVar} (assuming nested variable(s)).}

\item{rowAutoMerge}{(flextable output) Logical, if TRUE (by default) automatically merge rows,
e.g. in case there is only one sub-category (e.g. categorical variable with only one group)
or only one statistic per category.}

\item{emptyValue}{String with placeholder used to fill the table for missing values, '-' by default.
This value is typically used e.g. if not all statistics are computed for all specified
row/col/var variables.}

\item{rowVarTotalPerc}{Character vector with row variables by which the total
should be computed for the denominator for the percentage computation.
By default the total is only computed only by column (NULL by default).
If the total should be based on the total number of records per variable,
\code{rowVarTotalPerc} should be set to 'variable'.}

\item{colVar}{Character vector with variable(s) to be included in columns.
If multiple variables are specified, the variables should 
be sorted in hierarchical order,
and are included in multi-columns layout.\cr
Use: 'variable' to include the variables to summarize: \code{var}
 (if multiple) in different columns.}

\item{colVarTotal}{String with column(s) considered to compute the total by,
reported in the header of the table, by default same as \code{colVar}.
Use: 'variable' to compute total by \code{var} (if multiple).}

\item{colVarTotalPerc}{String with column(s) considered to compute the total by,
used as denominator for the percentage computation, by default same as \code{colVarTotal}.
Use: 'variable' to compute total by \code{var} (if multiple).}

\item{colInclude0}{Logical, if TRUE (FALSE by default),
include columns with no records, based on all combinations 
of the \code{columnVar} (assuming nested variable(s)).
If variable(s) are not nested, possible combinations
can be specified via \code{colVarDataLevels}.}

\item{colVarDataLevels}{Data.frame with unique combinations of \code{colVar}
to be included in columns.
Each column should correspond to \code{colVar} and as factor
if the elements should be ordered in the final table.}

\item{colTotalInclude}{Logical, if TRUE (FALSE by default) include the summary 
statistics across columns in a separated column.}

\item{colTotalLab}{String, label for the total column  'Total' by default.\cr}

\item{stats}{(optional) Statistic(s) of interest to compute, either:
\itemize{
\item{string with the name of a default set of statistics
available in the package, 
see section 'Formatted statistics' in
\code{\link[=inTextSummaryTable-stats]{in-text table statistics}}.\cr
See the corresponding \code{type} parameter of the
\code{\link{getStatsData}} for more information
on how the statistic is internally extracted.}
\item{(expert mode) named list of language object (see \code{\link{is.language}}) 
of base summary statistics of interest, see section:
'Base statistics' in
\code{\link[=inTextSummaryTable-stats]{in-text table statistics}}.\cr
The names are reported in the header.\cr
If \code{stats} if of length 1, the name of the summary statistic is not included
in the table.\cr
The statistics can be specified separately:
\itemize{
\item{for each \code{var} (if multiple), 
by naming each element of the list:
\code{list(varName1 = list(...), varName2 = list())}
}
\item{and/or for each element in:
\code{statsVarBy}, by naming each sublist.}
}}
}}

\item{statsExtra}{(optional) Named list with functions for additional custom
statistics to be computed.\cr
Each function:
\itemize{
\item{has as parameter, either: 'x': the variable (\code{var}) to compute
the summary statistic on or 'data': the entire dataset}
\item{returns the corresponding summary statistic as a numeric vector}
}
For example, to additionally compute the coefficient of variation, this can be set to:
\code{list(statCVPerc = function(x) sd(x)/mean(x)*100)} (or \code{\link{cv}}).}

\item{statsVarBy}{String with variable in \code{rowVar}/\code{colVar}
which the statistics should be computed by.\cr
In this case, \code{stats} (nested list or not) should be additionally nested
to specify the statistics for each element in \code{statsVarBy}.}

\item{statsPerc}{String with 'base statistical variable' used to compute the 
percentage, either: 
\itemize{
\item{'statN' (by default): the number of subjects}
\item{'statm': the number of records}
}}

\item{statsGeneralLab}{String with general label for statistics, 'Statistic' by default.
Only included if no \code{statsVar} if longer than 1.}

\item{statsValueLab}{String with label for the statistic value, 
'StatisticValue' by default.\cr
This is only included in the table if the statistics provided in 
\code{stats} are not named and if no \code{colVar} is specified.}

\item{statsLabInclude}{Logical, if TRUE include the statistic label
in the table. \cr By default only included if more than
one statistic variables are available in the table.}

\item{subjectVar}{String, variable of \code{data} with subject ID,
'USUBJID' by default.}

\item{filterFct}{(optional) Function taking as input
the summary table with computed statistics and returning a subset 
of the summary table.\cr
Note: The filtering function should also handle records with :
\itemize{
\item{total for the column header: \code{isTotal} set to TRUE,
and \code{colVar}/\code{rowVar} is NA.\cr
For example: \code{filterFct = function(data) subset(data, isTotal & myColVar == "group 1")}
}
\item{\code{rowVar}/\code{colVar} set to 'Total'/\code{colTotalLab} 
if \code{rowVarTotalInclude}/\code{colTotalInclude} is specified}
}}

\item{dataTotal}{Data.frame used to extract the Total number of subject
per column in column header ('N = [X]').
It should contain the variables specified by \code{colVarTotal}.
If not specified, the total number of subjects is extracted from the \code{data}.}

\item{dataTotalPerc}{Data.frame used to extract the total counts per column 
for the computation of the percentage.\cr
By default, \code{dataTotal} is used.\cr
It should contain the variables specified by \code{colVarTotalPerc}.}

\item{dataTotalRow}{Data.frame used to extract the total count across all
elements of the row
variable, list of such data.frame for each \code{rowVar} variable.\cr
If the dataset is specified by row variable, the list should be named with:
variable X if the total across elements of variable X should be included.
By default, \code{data} is used.}

\item{dataTotalCol}{Data.frame from which the total across columns is 
extracted (in case \code{colTotalInclude} is TRUE)
or list of such data.frame for each \code{rowVar} variable.\cr
If the dataset is specified by row variable, the list should be named with:
with:
\itemize{
\item{last row variable: for the dataset used in the total column for 
the most nested row variable}
\item{higher row variable (X+1): for the dataset used for the total column
and row total of X}
\item{'total': for the dataset used for the total column and general row total}
}
If only a subset of the variables is specified in this list, 
\code{data} is used for the remaining variable(s) (or 'total') if needed.\cr
This dataset (the one for 'total' if a list) is also used for:
\itemize{
\item{the header of the total column in case \code{dataTotal} is
not specified}
\item{the denominator of the percentages in the total column
in case \code{dataTotalPerc} is not specified}
}
By default, \code{data} is used.}

\item{type}{String with type of table: 
\itemize{
\item{'summaryTable': summary table with statistics for numeric variable}
\item{'countTable': count table}
\item{'auto' (by default): 'summaryTable' if the variable is numeric,
'countTable' otherwise}
}}

\item{byVar}{Variable(s) of \code{data} for which separated table(s)
should be created.}

\item{byVarLab}{String with label for \code{byVar}, used to set the names
of the output list of table(s).}

\item{checkVarDiffBySubj}{String, 'error' (default), 'warning',
or 'none'.  
Should an error, a warning, or nothing be produced
if a continuous variable (\code{var}) contains
different values for the same subject (by row/column)?}

\item{labelVars}{(optional) Named character vector with label for
the row, column variable(s) or variable(s) to summarize. \cr
Labels specified via dedicated parameter: e.g. 
\code{rowVarLab}, \code{colVarLab}, \code{varLab}
have priority on this parameter.}

\item{outputType}{String with output type:
\itemize{
\item{'flextable' (by default): \code{\link[flextable]{flextable}} object, with format for
CSR, compatible with Word/PowerPoint export}
\item{'DT': \code{\link[DT]{datatable}} interactive table,
compatible with html export}
\item{'data.frame': data.frame in wide format (with elements in 
\code{colVar} in different columns)}
\item{'data.frame-base': data.frame in long format (with elements in 
\code{colVar} in different rows), useful for QC}
}}

\item{statsLayout}{String with layout for the statistics names 
(in case more than one statistic is included), among:
\itemize{
\item{row (by default for 'flextable' output): \cr All statistics are
 included in different rows in the first column of the table (after the row variable(s))}
\item{'col' (by default for 'DT' output): \cr Statistics are included 
in separated columns (last row of the header).\cr
This option is not compatible with categorical variable(s).}
\item{'rowInSepCol': \cr Statistics are included in different rows, 
but in a separated column than the \code{rowVar} variable(s)}
}}

\item{landscape}{(flextable output) Logical, if TRUE the file is in landscape format.\cr
By default: FALSE if \code{style} is 'report' and TRUE if \code{style} is 'presentation'.}

\item{margin}{(flextable output) Margin in the document in inches
(1 by default).
This is used to specify the width of the table, from:
[\code{pageDim[1]} - 2 * margin].}

\item{rowPadBase}{(flextable output) Base padding for row (in points), 
14.4 by default (corresponds to 0.2 inches)}

\item{title}{Character vector with title(s) for the table.
Set to NULL (by default) if no title should be included.
If multiple are specified, specified for each element of \code{byVar} (in order of the levels).}

\item{footer}{(flextable output) Character vector with footer(s) for the table.
Set to NULL (by default) if no footer should be included.}

\item{file}{(Optional) Name of the file the table should be exported to, 
either:
\itemize{
\item{string (of length 1). In this case, depending on the
file extension, the following is exported: 
\itemize{
\item{'txt': summary table in long format ('data.frame-base' \code{outputType})}
\item{'docx': summary table in final format is exported ('flextable' \code{outputType})}
\item{'html': interactive summary table is exported ('DT' \code{outputType})}
}}
\item{named character vector in case of multiple exports.
The names should correspond to the options in \code{outputType}:
\itemize{
\item{for 'data.frame-base' and 'data.frame': filename with 'txt' extension}
\item{for 'flextable': filename with 'docx' extension}
\item{for 'DT': filename with 'html' extension}
}}
}
If NULL (by default), the summary table is not exported but only returned as output.
If \code{byVar} is specified, each table is exported to a separated
file with the suffix: 'file_[i].[ext]' with i the index of the file
(and [ext] the file extension).}

\item{style}{(flextable output) String with table style,
 either 'report' or 'presentation'.
This parameter affects the fontsize, font family, color of the text and background, 
and table dimensions of the table.}

\item{colorTable}{(flextable output) Named character vector with color for the table background/body/text/line,
e.g. created with the \code{\link{getColorPaletteTable}} function.}

\item{colHeaderTotalInclude}{Logical, if TRUE include the total of number of patients
(\code{'statN'}) in the column header.}

\item{colHeaderMerge}{(flextable output) Logical, if TRUE (FALSE by default) 
the column header is merged.}

\item{fontsize}{(flextable output) Integer with font size, by default:
8 if \code{style} is 'report' and 10 if \code{style} is 'presentation'.}

\item{fontname}{(flextable output) String with font name, by default:
'Times' if \code{style} is 'report' and 'Tahoma' if \code{style} is 'presentation'.}

\item{vline}{(flextable output) String mentioning how vertical lines 
should be included in the body of the table, either: 
\itemize{
\item{'none' (default): no vertical lines included}
\item{'auto': vertical lines included between sub-groups}
}}

\item{hline}{(flextable output) String mentioning how horizontal lines 
should be included in the body of the table, either: 
\itemize{
\item{'none': no horizontal lines included}
\item{'auto' (default): horizontal lines included between sub-groups}
}}

\item{pageDim}{Numeric vector of length 2 with page width and height.\cr
Depending on \code{outputType}:
\itemize{
\item{'flextable': in inches}
\item{'DT': in number of rows in the table.\cr
Currently only the height is used (e.g. \code{c(NA, 4)})
}}}

\item{columnsWidth}{(expert mode) Column widths of the table. This is only used 
for flextable and DT tables.\cr
For flextable, note that the widths should be set to fit into the document page
(see \code{\link{getDimPage}}).}

\item{expandVar}{(DT output) Character vector with variables of the summary table which
should be expanded in the data.}

\item{noEscapeVar}{(DT output) Character vector with variables of \code{summaryTable}
which shouldn't be escaped in the table (e.g. containing URLs).}

\item{barVar}{(DT output) Character vector with variables of \code{summaryTable}
that should be represented as a bar.}

\item{...}{(DT output) Extra parameters passed to the 
\code{\link[clinUtils]{getClinDT}}}
}
\value{
Depending on the \code{outputType}:
\itemize{
\item{'data.frame-base': input summary table in a long format with
all computed statistics}
\item{'data.frame': summary table in a wide format (
different columns for each \code{colVar}), with specified labels}
\item{'flextable' (by default): \code{\link[flextable]{flextable}}
 object with summary table}
\item{'DT': \code{\link[DT]{datatable}} object with summary table}
}
If multiple \code{outputType} are specified, a list of those objects, named
by \code{outputType}.\cr
If \code{byVar} is specified, each object consists of a list of tables,
one for each element in \code{byVar}.
}
\description{
Get summary statistics table
}
\author{
Laure Cougnaud
}
