% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{get.adjacency}
\alias{get.adjacency}
\title{Convert a graph to an adjacency matrix}
\usage{
get.adjacency(
  graph,
  type = c("both", "upper", "lower"),
  attr = NULL,
  edges = FALSE,
  names = TRUE,
  sparse = igraph_opt("sparsematrices")
)
}
\arguments{
\item{graph}{The graph to convert.}

\item{type}{Gives how to create the adjacency matrix for undirected graphs.
It is ignored for directed graphs. Possible values: \code{upper}: the upper
right triangle of the matrix is used, \code{lower}: the lower left triangle
of the matrix is used. \code{both}: the whole matrix is used, a symmetric
matrix is returned.}

\item{attr}{Either \code{NULL} or a character string giving an edge
attribute name. If \code{NULL} a traditional adjacency matrix is returned.
If not \code{NULL} then the values of the given edge attribute are included
in the adjacency matrix. If the graph has multiple edges, the edge attribute
of an arbitrarily chosen edge (for the multiple edges) is included. This
argument is ignored if \code{edges} is \code{TRUE}.

Note that this works only for certain attribute types. If the \code{sparse}
argumen is \code{TRUE}, then the attribute must be either logical or
numeric. If the \code{sparse} argument is \code{FALSE}, then character is
also allowed. The reason for the difference is that the \code{Matrix}
package does not support character sparse matrices yet.}

\item{edges}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Logical scalar, whether to return the edge ids in the matrix.
For non-existant edges zero is returned.}

\item{names}{Logical constant, whether to assign row and column names
to the matrix. These are only assigned if the \code{name} vertex attribute
is present in the graph.}

\item{sparse}{Logical scalar, whether to create a sparse matrix. The
\sQuote{\code{Matrix}} package must be installed for creating sparse
matrices.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{get.adjacency()} was renamed to \code{\link[=as_adjacency_matrix]{as_adjacency_matrix()}} to create a more
consistent API.
}
\keyword{internal}
