% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accumulate_downstream.R
\name{accumulate_downstream}
\alias{accumulate_downstream}
\alias{accumulate_downstream.data.frame}
\alias{accumulate_downstream.hy}
\title{Accumulate Variable Downstream}
\usage{
accumulate_downstream(x, var)

\method{accumulate_downstream}{data.frame}(x, var)

\method{accumulate_downstream}{hy}(x, var)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{var}{variable to accumulate.}
}
\value{
vector of the same length as \code{nrow(x)} containing values of \code{var} accumulated downstream
}
\description{
given a variable, accumulate according to network topology.
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

x$totDASqKM <- accumulate_downstream(add_toids(x), "AreaSqKM")

plot(x['totDASqKM'], lwd = x$totDASqKM / 50)
}
