% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmaxC.R
\name{pmaxC}
\alias{pmaxC}
\alias{pminC}
\alias{pmaxV}
\alias{pminV}
\alias{pmax0}
\alias{pmin0}
\alias{pmax3}
\alias{pmin3}
\title{Parallel maximum/minimum}
\usage{
pmaxC(
  x,
  a,
  in_place = FALSE,
  keep_nas = FALSE,
  dbl_ok = TRUE,
  nThread = getOption("hutilscpp.nThread", 1L)
)

pminC(
  x,
  a,
  in_place = FALSE,
  keep_nas = FALSE,
  dbl_ok = TRUE,
  nThread = getOption("hutilscpp.nThread", 1L)
)

pmax0(
  x,
  in_place = FALSE,
  sorted = FALSE,
  keep_nas = FALSE,
  nThread = getOption("hutilscpp.nThread", 1L)
)

pmin0(
  x,
  in_place = FALSE,
  sorted = FALSE,
  keep_nas = FALSE,
  nThread = getOption("hutilscpp.nThread", 1L)
)

pmaxV(
  x,
  y,
  in_place = FALSE,
  dbl_ok = TRUE,
  nThread = getOption("hutilscpp.nThread", 1L)
)

pminV(
  x,
  y,
  in_place = FALSE,
  dbl_ok = TRUE,
  nThread = getOption("hutilscpp.nThread", 1L)
)

pmax3(x, y, z, in_place = FALSE)

pmin3(x, y, z, in_place = FALSE)
}
\arguments{
\item{x}{\describe{
\item{\code{numeric(n)}}{A numeric vector.}
}}

\item{a}{\describe{\item{\code{numeric(1)}}{A single numeric value.}}}

\item{in_place}{\describe{
\item{\code{TRUE | FALSE}, default: \code{FALSE}}{Should \code{x} be modified in-place? For advanced use only.}
}}

\item{keep_nas}{\describe{
\item{\code{TRUE | FALSE}, default: \code{FALSE}}{Should \code{NA}s values be
preserved? By default, \code{FALSE}, so the behaviour of the function is
dependent on the representation of \code{NA}s at the C++ level.}
}}

\item{dbl_ok}{\describe{
\item{\code{TRUE | FALSE}, default: \code{TRUE}}{Is it acceptable to return
a non-integer vector if \code{x} is integer? If \code{TRUE}, the default,
if \code{x} is an integer vector, a double vector may be returned if
\code{a} is not an integer.}
}}

\item{nThread}{\describe{
\item{\code{integer(1)}}{The number of threads to use. Combining \code{nThread > 1}
and \code{in_place = TRUE} is not supported.}
}}

\item{sorted}{\describe{
\item{\code{TRUE | FALSE}, default: \code{FALSE}}{
Is \code{x} known to be sorted?
If \code{TRUE}, \code{x} is assumed to be sorted. Thus the
first zero determines whether the position at which zeroes start or end.}
}}

\item{y, z}{\describe{\item{\code{numeric(n)}}{Other numeric vectors the same length as \code{x}}}}
}
\value{
Versions of \code{pmax} and \code{pmin}, designed for performance.

When \code{in_place = TRUE}, the values of \code{x} are modified in-place.
For advanced users only.

The differences are:
\describe{
\item{\code{pmaxC(x, a)} and \code{pminC(x, a)}}{Both \code{x} and \code{a} must be numeric and
\code{a} must be length-one.}
}
}
\description{
Faster \code{pmax()} and \code{pmin()}.
}
\note{
This function will always be faster than \code{pmax(x, a)} when \code{a} is
a single value, but can be slower than \code{pmax.int(x, a)} when \code{x} is short.
Use this function when comparing a numeric vector with a single value.

Use \code{in_place = TRUE} only within functions when you are sure it is safe, i.e. not a
reference to something outside the environment.

By design, the functions first check whether \code{x} will be modified before
allocating memory to a new vector. For example, if all values in \code{x} are
nonnegative, the vector is returned.
}
\examples{
pmaxC(-5:5, 2)

}
