% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumsum_reset.R
\name{cumsum_reset}
\alias{cumsum_reset}
\title{Cumulative sum unless reset}
\usage{
cumsum_reset(x, y = as.integer(x))
}
\arguments{
\item{x}{A logical vector indicating when the sum should \emph{continue}.}

\item{y}{Optional: a numeric vector the same length as \code{x} to cumulatively sum.}
}
\value{
If \code{y} is a double vector, a double vector of cumulative sums,
resetting whenever \code{x} is \code{FALSE}; otherwise an integer vector.

If \code{length(x) == 0}, \code{y} is returned (i.e. \code{integer(0)} or \code{double(0)}.
}
\description{
Cumulative sum unless reset
}
\examples{
cumsum_reset(c(TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, FALSE))
cumsum_reset(c(TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, FALSE),
             c(1000, 1000, 10000,   10,   20,   33,     0))

}
