% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.nearby.snp.lists}
\alias{get.nearby.snp.lists}
\title{Obtain nearby SNP-lists within a recombination window}
\usage{
get.nearby.snp.lists(snpid.list, cM = 0.1, bp.ext = 0, excl.snps = NULL,
  name.by.bands = TRUE)
}
\arguments{
\item{snpid.list}{character, list of snp-ids (e.g, rs-id or chip id) to obtain lists for.
SNPs must all be from the same chromosome - if ranges for SNPs spanning multiple ranges
are desired, you must use multiple calls. A warning will be given if SNPs from the same
karyotype band are entered as index SNPs, as in a typical GWAS analysis only one SNP would
be used like this from each region, ignore the warning if this is not the case for your
application.}

\item{cM}{numeric, the number of centimorgans to extend the window either side of each SNP}

\item{bp.ext}{numeric, optional number of base-pairs to extend the window by in addition
to the centimorgan extension}

\item{excl.snps}{character, a list of rs-id or chip-ids of SNPs to exclude from the list
returned, as, for instance, they may have failed quality control such as call-rate.}

\item{name.by.bands}{give labels to each sublist returned by the karotype/cytoband name, 
but faster not to do this}
}
\value{
Returns a list of vectors of snp-ids falling within the window(s) specified and not
in 'excl.snps'. Each snp in 'snpid.list' will correspond to an element in the list returned.
If name.by.bands is TRUE, then these list elements will each be named using the local
karyotype/cytoband location
}
\description{
For a snp.id (or list), extend a window around that chromosome location in recombination
units (centimorgans) and return the list of SNPs from the current ChipInfo object that
lie in this window. This is a way of extracting SNPs in linkage disequilibrium with an 
index SNP, that could also be plausible causal candidates. Runs fastest for build 36,
otherwise internal conversion takes place (runs using build based on getOptions('ucsc')).
}
\examples{
# examples not run as too slow
\donttest{
result <- get.nearby.snp.lists("rs900569")
# trick below to extract SNPs within 0.1-0.2cM
get.nearby.snp.lists("rs900569",cM=0.2,excl.snps=result[[1]]) 
# note that the same query can return a different set with build 36 versus 37
get.nearby.snp.lists(c("rs689","rs4909944"),cM=0.001,name.by.bands=FALSE) 
}
}
\seealso{
\code{\link{snps.in.range}}, \code{\link{get.recombination.map}}, 
\code{\link{recomWindow}}, \code{\link{conv.37.36}}, \code{\link{conv.36.37}}, \code{\link{expand.nsnp}}
}
