% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.genic.subset}
\alias{get.genic.subset}
\title{Obtain subset of ranged object overlapping human genes}
\usage{
get.genic.subset(X, ref = NULL, build = NULL)
}
\arguments{
\item{X}{GRanges or RangedData object, ranged object for which you want the genic subset
of ranges/SNPs.}

\item{ref}{GRanges or RangedData object, only use if you need to provide for a
build other than 36 or 37 (hg18/hg19), or to use this function for another reference set,
for instance you could provide an object with exons}

\item{build}{e.g, 36/hg18 or 37/hg19, if left as NULL current getOption('ucsc') will
be used.}
}
\value{
a GRanges object with the specified genic (or custom) ranges
}
\description{
Return subset of a ranged object that overlaps human genes (or custom ranges/exons).
A wrapper for subsetByOverlaps that tries to ensure equivalent builds and chromosome
labelling are taken care of automatically, and provides the default case of genic subsetting
where no explicit ref parameter is required.
}
\examples{
\donttest{
# all.reg <- rranges(1000) # random set of 1000 regions
# genic <- get.genic.subset(all.reg) # gene regions from the random set
# exonic <- get.genic.subset(all.reg,ref=get.exon.annot()) # exonic regions from the random set
}
}
\seealso{
\code{\link{get.gene.annot}}, \code{\link{get.exon.annot}}, \code{\link{subsetByOverlaps}}
}
