% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_kramer.R
\name{parameterize_kramer}
\alias{parameterize_kramer}
\title{Parameterize Kramer IVD Model}
\usage{
parameterize_kramer(
  tcdata = NA,
  casrn.vector = NA_character_,
  this.FBSf = NA_real_,
  this.BSA = 44,
  this.v_total = NA_real_,
  this.v_working = NA_real_,
  this.cell_yield = NA_real_,
  this.sarea = NA_real_,
  this.prot_conc = 0.21
)
}
\arguments{
\item{tcdata}{A data table with well_number corresponding to plate format,
optionally include v_working, sarea, option.bottom, and option.plastic}

\item{casrn.vector}{A deprecated argument specifying a single or vector of 
Chemical Abstracts Service Registry 
Number(s) (CAS-RN) of desired chemical(s).}

\item{this.FBSf}{Fraction fetal bovine serum}

\item{this.BSA}{bovine serum albumin concentration (g/L)}

\item{this.v_total}{Total volume per well (uL)}

\item{this.v_working}{Working volume per well (uL)}

\item{this.cell_yield}{Number of cells/well seeded}

\item{this.sarea}{Surface area per well (m^2)}

\item{this.prot_conc}{Cell protein concentration (mg protein/million cells)}
}
\value{
A data table composed of any input data.table \emph{tcdata}
with only the following columns either created or altered by this function:
\tabular{ccc}{
\strong{Column Name} \tab \strong{Description} \tab \strong{Units} \cr
sarea \tab surface area \tab m^2 \cr
v_working_m3 \tab working (filled) volume of each well \tab m^3 \cr
v_total_m3 \tab total volume of each well \tab m^3 \cr
v_headspace_m3 \tab volume of headspace per well \tab m^3 \cr
conc_BSA \tab BSA concentration in media \tab kg/L \cr 
FBSp \tab Percent fetal bovine serum in media \tab percent \cr
conc_cell_mg \tab concentration of cell lipids \tab mg/m^3 \cr
conc_cell \tab concentration of cell lipids \tab kg/m^3 \cr 
conc_plastic \tab concentration of plastic \tab m2/m^3 \cr 
}
}
\description{
This function takes inputs from kramer_eval() and calls parameterize_IVD(). Converts units and sets up variables for kramer_eval().
}
\references{
\insertRef{kramer2010measuring}{httk}
}
\author{
Meredith Scherer
}
