% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_lca.R
\docType{class}
\name{LcaFit-class}
\alias{LcaFit-class}
\title{Latent Class  Analysis fit results class}
\description{
An S4 class to represent a fit of a Latent Class Analysis model
  for categorical data clustering, extend \code{\link{IclFit-class}}. The
  original data must be an n x p matrix where p is the number of variables
  and each variable is encoded as a factor (integer-valued).
}
\section{Slots}{

\describe{
\item{\code{model}}{a \code{\link{Lca-class}} object to store the model fitted}

\item{\code{name}}{generative model name}

\item{\code{icl}}{icl value of the fitted model}

\item{\code{K}}{number of extracted clusters over row and columns}

\item{\code{cl}}{a numeric vector with cluster indexes}

\item{\code{obs_stats}}{a list with the following elements: \itemize{ \item counts:
numeric vector of size K with number of elements in each clusters \item
x_counts: matrix of size K*D with the number of occurrences of each
modality for each clusters }}

\item{\code{move_mat}}{binary matrix which store move constraints}

\item{\code{train_hist}}{data.frame with training history information (details
depends on the training procedure)}
}}

\seealso{
\code{\link{coef,LcaFit-method}}
}
