% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_2w_Tdeath}
\alias{data_2w_Tdeath}
\title{In vitro measurement of percentage cell death - two-way ANOVA design with repeated measures, and randomised blocks.}
\format{
data.frame:	24 obs. of  6 variables:

\describe{
\item{Experiment}{A random factor with 6 levels "e1", "e2"...}
\item{Time}{A fixed factor with 2 levels: "t100" & "t300".}
\item{Time2}{A numeric column that allows plotting data on a quantitative "Time" axis. The "Time" column has "factor" type values that should be used for the ANOVA..}
\item{Genotype}{A fixed factor with 2 levels that we want to compare "WT" & "KO".}
\item{Subject}{A random factor with 12 levels: "s1", "s2"... These are cell culture wells that were measured at two time points, and indicate "subjects" that underwent repeated-measures within each of 6 experiments. Subject IDs for WT and KO are unique and clearly indicate different wells.}
\item{PI}{Numerical dependent variable indicating propidium iodide dye uptake as a measure of cell death. These are percentage of dead cells out of total cells plated.}
}
}
\usage{
data_2w_Tdeath
}
\description{
These are measurements of death of infected host cells (as percentage of total cells) upon infection with two strains of bacteria, measured at two time points, in 6 independent experiments.  These data repeated-measures data suitable for two-way linear mixed effects modelling with experiment and subjects as random factors.
}
\keyword{datasets}
