% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMVARconstruction.R
\name{stmvar_to_gstmvar}
\alias{stmvar_to_gstmvar}
\title{Estimate a G-StMVAR model based on a StMVAR model that has large degrees of freedom parameters}
\usage{
stmvar_to_gstmvar(
  gsmvar,
  estimate,
  calc_std_errors = estimate,
  maxdf = 100,
  maxit = 100
)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{estimate}{set \code{TRUE} if the new model should be estimated with a variable metric algorithm
using the StMAR model parameter value as the initial value. By default \code{TRUE} iff the model
contains data.}

\item{calc_std_errors}{set \code{TRUE} if the approximate standard errors should be calculated.}

\item{maxdf}{regimes with degrees of freedom parameter value larger than this will be turned into
GMVAR type.}

\item{maxit}{the maximum number of iterations for the variable metric algorithm. Ignored if \code{estimate==FALSE}.}
}
\value{
Returns an object of class \code{'gsmvar'} defining a G-StMVAR model based on the provided StMVAR (or G-StMVAR)
  model with the regimes that had large degrees of freedom parameters changed to GMVAR type.
}
\description{
\code{stmvar_to_gstmvar} estimates a G-StMVAR model based on a StMVAR model that has
 large degrees of freedom parameters.
}
\details{
If a StMVAR model contains large estimates for the degrees of freedom parameters,
  one should consider switching to the corresponding G-StMAR model that lets the corresponding
  regimes to be GMVAR type. \code{stmvar_to_gstmvar} does this switch conveniently. Also G-StMVAR models
  are supported if some of the StMVAR type regimes have large degrees of freedom paraters.

  Note that if the model imposes constraints on the autoregressive parameters, or if a structural model imposes
  constraints on the lambda parameters, and the ordering the regimes changes, the constraints are removed from
  the model. This is because of the form of the constraints that does not generally allow to switch the ordering
  of the regimes. If you wish to keep the constraints, you may construct the resulting G-StMVAR model parameter
  vector by hand, redefine your constraints accordingly, build the model with the function \code{GSMVAR}, and then
  estimate it with the function \code{iterate_more}. Alternatively, you can always directly estimate the constrained
  G-StMVAR model with the function \code{fitGSMVAR}.
}
\examples{
\donttest{
# StMVAR(1, 2), d=2 model:
params12t <- c(0.5453, 0.1157, 0.331, 0.0537, -0.0422, 0.7089, 0.4181, 0.0018,
  0.0413, 1.6004, 0.4843, 0.1256, -0.0311, -0.6139, 0.7221, 1.2123, -0.0357,
  0.1381, 0.8337, 7.5564, 90000)
mod12t <- GSMVAR(gdpdef, p=1, M=2, params=params12t, model="StMVAR")
mod12t

# Switch to the G-StMVAR model:
mod12gs <- stmvar_to_gstmvar(mod12t)
mod12gs
}
}
\references{
\itemize{
   \item Muirhead R.J. 1982. Aspects of Multivariate Statistical Theory, \emph{Wiley}.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
   \item Virolainen S. 2025. A statistically identified structural vector autoregression with endogenously
          switching volatility regime. \emph{Journal of Business & Economic Statistics}, \strong{43}, 1, 44-54.
 }
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{swap_W_signs}}, \code{\link{gsmvar_to_sgsmvar}}
}
