% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme4_functions.R
\name{lme4_to_glmmr}
\alias{lme4_to_glmmr}
\title{Map lme4 formula to glmmrBase formula}
\usage{
lme4_to_glmmr(formula, cnames)
}
\arguments{
\item{formula}{A lme4 style formula}

\item{cnames}{The column names of the data to be used. These are used to check if the specified clustering variables are in 
the data.}
}
\value{
A formula.
}
\description{
Returns a formula that can be used for glmmrBase Models from an lme4 input.
}
\details{
The package lme4 uses a syntax to specify random effects as `(1|x)` where `x` is the grouping variable.
This function will modify such a formula, including those with nesting and crossing operators `/` and `:` into
the glmmrBase syntax using the `gr()` function. Not typically required by the user as it is used internally 
in the `mcml_lmer` and `mcml_glmer` functions.
}
\examples{
df <- data.frame(cl = 1:3, t = 4:6)
f1 <- lme4_to_glmmr(y ~ x + (1|cl/t),colnames(df))
}
