% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential.R
\name{cred_ssh_key}
\alias{cred_ssh_key}
\title{Create a new passphrase-protected ssh key credential object}
\usage{
cred_ssh_key(publickey = ssh_path("id_rsa.pub"),
  privatekey = ssh_path("id_rsa"), passphrase = character(0))
}
\arguments{
\item{publickey}{The path to the public key of the
credential. Default is \code{ssh_path("id_rsa.pub")}}

\item{privatekey}{The path to the private key of the
credential. Default is \code{ssh_path("id_rsa")}}

\item{passphrase}{The passphrase of the credential. Default is
\code{character(0)}. If getPass is installed and private key
is passphrase protected \code{getPass::getPass()} will be
called to allow for interactive and obfuscated interactive
input of the passphrase.}
}
\value{
A list of class \code{cred_ssh_key} with entries:
\describe{
  \item{publickey}{
    The path to the public key of the credential
  }
  \item{privatekey}{
    The path to the private key of the credential
  }
  \item{passphrase}{
    The passphrase of the credential
  }
}
}
\description{
Create a new passphrase-protected ssh key credential object
}
\examples{
\dontrun{
## Create a ssh key credential object. It can optionally be
## passphrase-protected
cred <- cred_ssh_key(ssh_path("id_rsa.pub"), ssh_path("id_rsa"))
repo <- repository("git2r")
push(repo, credentials = cred)
}
}
\seealso{
Other git credential functions: \code{\link{cred_env}},
  \code{\link{cred_token}}, \code{\link{cred_user_pass}}
}
