% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars.R
\name{introduce}
\alias{introduce}
\title{Introduce non-existing columns}
\usage{
introduce(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A vector the same length as the current group (or the whole data frame
if ungrouped).
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}
}
\value{
a tibble with new columns
}
\description{
Works like \code{\link[dplyr:mutate]{dplyr::mutate()}} but without changing existing columns, but only
adding new ones. Useful to add possibly missing columns with default values.
}
\examples{
# ensure columns "y" and "z" exist
tibble::tibble(x = 1:3) \%>\%
  introduce(y = "a", z = paste0(y, dplyr::row_number()))
# ensure columns "y" and "z" exist, but do not overwrite "y"
tibble::tibble(x = 1:3, y = c("c", "d", "e")) \%>\%
  introduce(y = "a", z = paste0(y, dplyr::row_number()))
}
