% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convhulln.R
\name{convhulln}
\alias{convhulln}
\title{Compute smallest convex hull that encloses a set of points}
\usage{
convhulln(p, options = "Tv", output.options = NULL,
  return.non.triangulated.facets = FALSE)
}
\arguments{
\item{p}{An \eqn{M}-by-\eqn{N} matrix. The rows of \code{p}
represent \eqn{M} points in \eqn{N}-dimensional space.}

\item{options}{String containing extra options for the underlying
Qhull command; see details below and Qhull documentation at
\url{../doc/qhull/html/qconvex.html#synopsis}.}

\item{output.options}{String containing Qhull options to control
output. Currently \code{n} (normals) and \code{FA} (generalised
areas and volumes) are supported. Causes an object of return
value for details. If \code{output.options} is \code{TRUE},
select all supported options.}

\item{return.non.triangulated.facets}{logical defining whether the
output facets should be triangulated; \code{FALSE} by default.}
}
\value{
If \code{return.non.triangulated.facets} is \code{FALSE}
  (default), return an \eqn{M}-by-\eqn{N} index matrix of which
  each row defines an \eqn{N}-dimensional \dQuote{triangle}.

  If \code{return.non.triangulated.facets} is \code{TRUE} then the
  number of columns equals the maximum number of vertices in a
  facet, and each row defines a polygon corresponding to a facet
  of the convex hull with its vertices followed by \code{NA}s
  until the end of the row. The indices refer to the rows in
  \code{p}.

  If the \code{output.options} or \code{options} argument contains
  \code{FA} or \code{n}, return a list with class \code{convhulln}
  comprising the named elements:
  \describe{
    \item{\code{hull}}{The convex hull, represented as a matrix, as
      described above}
    \item{\code{area}}{If \code{FA} is specified, the generalised area of
      the hull. This is the surface area of a 3D hull or the length of
      the perimeter of a 2D hull.
      See \url{../doc/qhull/html/qh-optf.html#FA}.}
    \item{\code{vol}}{If \code{FA} is specified, the generalised volume of
       the hull. This is volume of a 3D hull or the area of a 2D hull.
       See \url{../doc/qhull/html/qh-optf.html#FA}. }
    \item{\code{normals}}{If \code{n} is specified, this is a matrix
    hyperplane normals with offsets. See \url{../doc/qhull/html/qh-opto.html#n}.}
  }
}
\description{
Returns an index matrix to the points of simplices
(\dQuote{triangles}) that form the smallest convex simplical
complex of a set of input points in \eqn{N}-dimensional space. This
function interfaces the Qhull library.
}
\details{
For silent operation, specify the option \code{Pp}.
}
\note{
This is a port of the Octave's (\url{http://www.octave.org})
geometry library. The Octave source was written by Kai Habel.

See further notes in \code{\link{delaunayn}}.
}
\examples{
# example convhulln
# ==> see also surf.tri to avoid unwanted messages printed to the console by qhull
ps <- matrix(rnorm(3000), ncol=3)  # generate points on a sphere
ps <- sqrt(3)*ps/drop(sqrt((ps^2) \%*\% rep(1, 3)))
ts.surf <- t(convhulln(ps))  # see the qhull documentations for the options
\dontrun{
rgl.triangles(ps[ts.surf,1],ps[ts.surf,2],ps[ts.surf,3],col="blue",alpha=.2)
for(i in 1:(8*360)) rgl.viewpoint(i/8)
}

}
\references{
\cite{Barber, C.B., Dobkin, D.P., and Huhdanpaa, H.T.,
\dQuote{The Quickhull algorithm for convex hulls,} \emph{ACM Trans. on
Mathematical Software,} Dec 1996.}

\url{http://www.qhull.org}
}
\seealso{
\code{\link[tripack]{convex.hull}}, \code{\link{delaunayn}},
\code{\link{surf.tri}}, \code{\link{distmesh2d}}, \code{\link{intersectn}}
}
\author{
Raoul Grasman, Robert B. Gramacy, Pavlo Mozharovskyi and David Sterratt
\email{david.c.sterratt@ed.ac.uk}
}
\keyword{dplot}
\keyword{graphs}
\keyword{math}
