% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODataIdentification19139.R
\docType{class}
\name{ISODataIdentification19139}
\alias{ISODataIdentification19139}
\title{ISODataIdentification19139}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO DataIdentification in ISO 19139
}
\description{
ISODataIdentification19139

ISODataIdentification19139
}
\examples{
   #create dataIdentification
   md <- ISODataIdentification$new()
   md$setAbstract("abstract")
   md$setPurpose("purpose")
   md$addLanguage("eng")
   md$addCharacterSet("utf8")
   md$addTopicCategory("biota")
   md$addTopicCategory("oceans")
   
   #adding a point of contact
   rp <- ISOResponsibleParty$new()
   rp$setIndividualName("someone")
   rp$setOrganisationName("somewhere")
   rp$setPositionName("someposition")
   rp$setRole("pointOfContact")
   contact <- ISOContact$new()
   phone <- ISOTelephone$new()
   phone$setVoice("myphonenumber")
   phone$setFacsimile("myfacsimile")
   contact$setPhone(phone)
   address <- ISOAddress$new()
   address$setDeliveryPoint("theaddress")
   address$setCity("thecity")
   address$setPostalCode("111")
   address$setCountry("France")
   address$setEmail("someone@theorg.org")
   contact$setAddress(address)
   res <- ISOOnlineResource$new()
   res$setLinkage("http://www.somewhereovertheweb.org")
   res$setName("somename")
   contact$setOnlineResource(res)
   rp$setContactInfo(contact)
   md$addPointOfContact(rp)
   
   #citation
   ct <- ISOCitation$new()
   ct$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   ct$addDate(d)
   ct$setEdition("1.0")
   ct$setEditionDate(ISOdate(2015, 1, 1, 1))
   ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
   ct$addPresentationForm("mapDigital")
   ct$addCitedResponsibleParty(rp)
   md$setCitation(ct)
   
   #graphic overview
   go <- ISOBrowseGraphic$new(
     fileName = "http://wwww.somefile.org/png",
     fileDescription = "Map Overview",
     fileType = "image/png"
   )
   md$addGraphicOverview(go)
   
   #maintenance information
   mi <- ISOMaintenanceInformation$new()
   mi$setMaintenanceFrequency("daily")
   md$addResourceMaintenance(mi)
   
   #adding legal constraints
   lc <- ISOLegalConstraints$new()
   lc$addUseLimitation("limitation1")
   lc$addUseLimitation("limitation2")
   lc$addUseLimitation("limitation3")
   lc$addAccessConstraint("copyright")
   lc$addAccessConstraint("license")
   lc$addUseConstraint("copyright")
   lc$addUseConstraint("license")
   md$addResourceConstraints(lc)
   
   #adding extent
   extent <- ISOExtent$new()
   bbox <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
   extent$addGeographicElement(bbox)
   md$addExtent(extent)
   
   #add keywords
   kwds <- ISOKeywords$new()
   kwds$addKeyword("keyword1")
   kwds$addKeyword("keyword2")
   kwds$setKeywordType("theme")
   th <- ISOCitation$new()
   th$setTitle("General")
   th$addDate(d)
   kwds$setThesaurusName(th)
   md$addKeywords(kwds)
   
   #supplementalInformation
   md$setSupplementalInformation("some additional information")
   
   xml <- md$encode()
   
}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/gmd/1.0/gmd/#element_MD_DataIdentification}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{data}
\keyword{identification}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOIdentification]{geometa::ISOIdentification}} -> \code{\link[geometa:ISOIdentification19139]{geometa::ISOIdentification19139}} -> \code{ISODataIdentification19139}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{spatialRepresentationType}}{spatialRepresentationType [0..*]: ISOSpatialRepresentationType}

\item{\code{spatialResolution}}{spatialResolution [0..*]: ISOResolution}

\item{\code{temporalResolution}}{[0..*]: ISOPeriodDuration}

\item{\code{language}}{language [1..*]: character}

\item{\code{characterSet}}{characterSet [0..*]: ISOCharacterSet}

\item{\code{topicCategory}}{topicCategory [0..*]: ISOTopicCategory}

\item{\code{environmentDescription}}{environment description [0..1]: character}

\item{\code{extent}}{extent [0..*]: ISOExtent}

\item{\code{supplementalInformation}}{supplementalInformation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISODataIdentification19139-new}{\code{ISODataIdentification19139$new()}}
\item \href{#method-ISODataIdentification19139-addSpatialRepresentationType}{\code{ISODataIdentification19139$addSpatialRepresentationType()}}
\item \href{#method-ISODataIdentification19139-delSpatialRepresentationType}{\code{ISODataIdentification19139$delSpatialRepresentationType()}}
\item \href{#method-ISODataIdentification19139-addSpatialResolution}{\code{ISODataIdentification19139$addSpatialResolution()}}
\item \href{#method-ISODataIdentification19139-delSpatialResolution}{\code{ISODataIdentification19139$delSpatialResolution()}}
\item \href{#method-ISODataIdentification19139-addLanguage}{\code{ISODataIdentification19139$addLanguage()}}
\item \href{#method-ISODataIdentification19139-setLanguage}{\code{ISODataIdentification19139$setLanguage()}}
\item \href{#method-ISODataIdentification19139-delLanguage}{\code{ISODataIdentification19139$delLanguage()}}
\item \href{#method-ISODataIdentification19139-addCharacterSet}{\code{ISODataIdentification19139$addCharacterSet()}}
\item \href{#method-ISODataIdentification19139-setCharacterSet}{\code{ISODataIdentification19139$setCharacterSet()}}
\item \href{#method-ISODataIdentification19139-delCharacterSet}{\code{ISODataIdentification19139$delCharacterSet()}}
\item \href{#method-ISODataIdentification19139-addTopicCategory}{\code{ISODataIdentification19139$addTopicCategory()}}
\item \href{#method-ISODataIdentification19139-delTopicCategory}{\code{ISODataIdentification19139$delTopicCategory()}}
\item \href{#method-ISODataIdentification19139-addExtent}{\code{ISODataIdentification19139$addExtent()}}
\item \href{#method-ISODataIdentification19139-delExtent}{\code{ISODataIdentification19139$delExtent()}}
\item \href{#method-ISODataIdentification19139-setSupplementalInformation}{\code{ISODataIdentification19139$setSupplementalInformation()}}
\item \href{#method-ISODataIdentification19139-clone}{\code{ISODataIdentification19139$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addAggregateInformation"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addAggregateInformation'><code>geometa::ISOIdentification19139$addAggregateInformation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addCredit"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addCredit'><code>geometa::ISOIdentification19139$addCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addFormat"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addFormat'><code>geometa::ISOIdentification19139$addFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addGraphicOverview"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addGraphicOverview'><code>geometa::ISOIdentification19139$addGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addKeywords"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addKeywords'><code>geometa::ISOIdentification19139$addKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addPointOfContact"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addPointOfContact'><code>geometa::ISOIdentification19139$addPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addResourceConstraints"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addResourceConstraints'><code>geometa::ISOIdentification19139$addResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addResourceMaintenance"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addResourceMaintenance'><code>geometa::ISOIdentification19139$addResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addResourceSpecificUsage"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addResourceSpecificUsage'><code>geometa::ISOIdentification19139$addResourceSpecificUsage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addStatus"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addStatus'><code>geometa::ISOIdentification19139$addStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delAggregateInformation"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delAggregateInformation'><code>geometa::ISOIdentification19139$delAggregateInformation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delCredit"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delCredit'><code>geometa::ISOIdentification19139$delCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delFormat"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delFormat'><code>geometa::ISOIdentification19139$delFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delGraphicOverview"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delGraphicOverview'><code>geometa::ISOIdentification19139$delGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delKeywords"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delKeywords'><code>geometa::ISOIdentification19139$delKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delPointOfContact"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delPointOfContact'><code>geometa::ISOIdentification19139$delPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delResourceConstraints"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delResourceConstraints'><code>geometa::ISOIdentification19139$delResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delResourceMaintenance"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delResourceMaintenance'><code>geometa::ISOIdentification19139$delResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delResourceSpecificUsage"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delResourceSpecificUsage'><code>geometa::ISOIdentification19139$delResourceSpecificUsage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delStatus"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delStatus'><code>geometa::ISOIdentification19139$delStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setAbstract"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setAbstract'><code>geometa::ISOIdentification19139$setAbstract()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setCitation"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setCitation'><code>geometa::ISOIdentification19139$setCitation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setGraphicOverview"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setGraphicOverview'><code>geometa::ISOIdentification19139$setGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setKeywords"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setKeywords'><code>geometa::ISOIdentification19139$setKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setPurpose"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setPurpose'><code>geometa::ISOIdentification19139$setPurpose()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setResourceMaintenance"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setResourceMaintenance'><code>geometa::ISOIdentification19139$setResourceMaintenance()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-addSpatialRepresentationType"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-addSpatialRepresentationType}{}}}
\subsection{Method \code{addSpatialRepresentationType()}}{
Adds spatial representation type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$addSpatialRepresentationType(
  spatialRepresentationType
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spatialRepresentationType}}{object of class \link{ISOSpatialRepresentationType} or
any \link{character} among values returned by \code{ISOSpatialRepresentationType$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-delSpatialRepresentationType"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-delSpatialRepresentationType}{}}}
\subsection{Method \code{delSpatialRepresentationType()}}{
Deletes spatial representation type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$delSpatialRepresentationType(
  spatialRepresentationType
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spatialRepresentationType}}{object of class \link{ISOSpatialRepresentationType} or
any \link{character} among values returned by \code{ISOSpatialRepresentationType$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-addSpatialResolution"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-addSpatialResolution}{}}}
\subsection{Method \code{addSpatialResolution()}}{
Adds spatial resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$addSpatialResolution(resolution)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resolution}}{object of class \link{ISOResolution}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-delSpatialResolution"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-delSpatialResolution}{}}}
\subsection{Method \code{delSpatialResolution()}}{
Deletes spatial resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$delSpatialResolution(resolution)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resolution}}{object of class \link{ISOResolution}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-addLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-addLanguage}{}}}
\subsection{Method \code{addLanguage()}}{
Adds language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$addLanguage(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLanguage} or any \link{character}
value among those returned by \code{ISOLanguage$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-setLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-setLanguage}{}}}
\subsection{Method \code{setLanguage()}}{
Sets language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$setLanguage(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLanguage} or any \link{character}
value among those returned by \code{ISOLanguage$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-delLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-delLanguage}{}}}
\subsection{Method \code{delLanguage()}}{
Deletes language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$delLanguage(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLanguage} or any \link{character}
value among those returned by \code{ISOLanguage$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-addCharacterSet"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-addCharacterSet}{}}}
\subsection{Method \code{addCharacterSet()}}{
Adds character set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$addCharacterSet(charset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{charset}}{object of class \link{ISOCharacterSet} or any \link{character}
value among those returned by \code{ISOCharacterSet$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-setCharacterSet"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-setCharacterSet}{}}}
\subsection{Method \code{setCharacterSet()}}{
Sets character set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$setCharacterSet(charset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{charset}}{object of class \link{ISOCharacterSet} or any \link{character}
value among those returned by \code{ISOCharacterSet$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-delCharacterSet"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-delCharacterSet}{}}}
\subsection{Method \code{delCharacterSet()}}{
Deletes character set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$delCharacterSet(charset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{charset}}{object of class \link{ISOCharacterSet} or any \link{character}
value among those returned by \code{ISOCharacterSet$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-addTopicCategory"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-addTopicCategory}{}}}
\subsection{Method \code{addTopicCategory()}}{
Adds topic category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$addTopicCategory(topicCategory)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{topicCategory}}{object of class \link{ISOTopicCategory} or any \link{character}
value among those returned by \code{ISOTopicCategory$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-delTopicCategory"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-delTopicCategory}{}}}
\subsection{Method \code{delTopicCategory()}}{
Deletes topic category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$delTopicCategory(topicCategory)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{topicCategory}}{object of class \link{ISOTopicCategory} or any \link{character}
value among those returned by \code{ISOTopicCategory$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-addExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-addExtent}{}}}
\subsection{Method \code{addExtent()}}{
Adds extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$addExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-delExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-delExtent}{}}}
\subsection{Method \code{delExtent()}}{
Deletes extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$delExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-setSupplementalInformation"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-setSupplementalInformation}{}}}
\subsection{Method \code{setSupplementalInformation()}}{
Set supplemental information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$setSupplementalInformation(
  supplementalInformation,
  locales = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{supplementalInformation}}{supplemental information}

\item{\code{locales}}{a list of localized information. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISODataIdentification19139-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISODataIdentification19139-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISODataIdentification19139$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
