% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{validate_variables_param}
\alias{validate_variables_param}
\title{Validate and Process Parameters for Variable Selection and Data Processing}
\usage{
validate_variables_param(
  variables,
  variables_all,
  prep_fun,
  aggr_funs,
  postp_funs
)
}
\arguments{
\item{variables}{[mandatory] (character or integer) Variable IDs or names to
be processed. Use \code{\link{fetch_vars}} to obtain valid variable names
or IDs. Accepts \code{"all"} to select all available variables.}

\item{variables_all}{[mandatory] (data.frame) A data frame containing all
available variables, typically obtained from \code{\link{fetch_vars}}.}

\item{prep_fun}{[mandatory] (function) A function used for pre-processing.}

\item{aggr_funs}{[mandatory] (function or list) Aggregation function(s).}

\item{postp_funs}{[mandatory] (function or list) Post-processing function(s).}
}
\value{
A character vector of variable names to process.
}
\description{
Validates and processes input parameters related to variable selection and
data processing in the \code{\link{read_db}} function. It ensures that the
variables, frequency, and functions provided are valid, correctly formatted,
and compatible with the available data.
}
\keyword{internal}
