% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_config.R
\name{modify_config}
\alias{modify_config}
\title{Modify Configuration File}
\usage{
modify_config(path, keys, new_values, verbose = TRUE)
}
\arguments{
\item{path}{[mandatory] (character) The path to the root directory of the
generated database.}

\item{keys}{[mandatory] (list) A list specifying the path to the values in
the configuration file that need updating. Each path should correspond to
a specific element in the configuration.}

\item{new_values}{[mandatory] (list) A list of new values to replace the
original values at the locations specified by 'keys'. The length of
\code{new_values} must match the length of \code{keys}.}

\item{verbose}{[optional] (logical) If \code{TRUE}, displays messages about
the updates made (default: \code{TRUE}).}
}
\value{
No return value, called for side effects.
}
\description{
Modifies the configuration file located in the specified root directory of
the generated database (\code{config/config.json}) by updating values
corresponding to the specified keys.
}
\examples{
# Example: Modifying the configuration file
\dontrun{
  modify_config(
    path = "path/to/db",
    keys = list("limit", c("source", "MODIS/061/MOD13A2", "NDVI")),
    new_values = list(1000, "mean")
  )
}
}
