% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_geelite.R,
%   R/run_geelite._halfgoogleimportR.R
\name{run_geelite}
\alias{run_geelite}
\title{Build and Update the Grid Statistics Database}
\usage{
run_geelite(
  path,
  conda = "rgee",
  user = NULL,
  rebuild = FALSE,
  mode = "local",
  verbose = TRUE
)

run_geelite(
  path,
  conda = "rgee",
  user = NULL,
  rebuild = FALSE,
  mode = "local",
  verbose = TRUE
)
}
\arguments{
\item{path}{[mandatory] (character) The path to the root directory of the
generated database. This must be a writable, non-temporary directory.
Avoid using the home directory (~), the current working directory, or the
package directory.}

\item{conda}{[optional] (character) Name of the virtual Conda environment
used by the \code{rgee} package (default: \code{"rgee"}).}

\item{user}{[optional] (character) Specifies the Google account directory
within \code{~/.config/earthengine/}. This directory stores credentials
for a specific Google account (default: \code{NULL}).}

\item{rebuild}{[optional] (logical) If \code{TRUE}, the database and its
supplementary files are overwritten based on the configuration file
(default: \code{FALSE}).}

\item{mode}{[optional] (character) Mode of data extraction. Currently
supports \code{"local"} or \code{"drive"} (for larger exports via Google
Drive). Defaults to \code{"local"}.}

\item{verbose}{[optional] (logical) Display computation status and messages
(default: \code{TRUE}).}
}
\value{
Invisibly returns NULL, called for side effects.

Invisibly returns NULL, called for side effects.
}
\description{
Collects and stores grid statistics from Google Earth Engine (GEE) data in
SQLite format (\code{data/geelite.db}), initializes CLI files
(\code{cli/...}), and initializes or updates the state
(\code{state/state.json}) and log (\code{log/log.txt}) files.

Collects and stores grid statistics from Google Earth Engine (GEE) data in
SQLite format (\code{data/geelite.db}), initializes CLI files
(\code{cli/...}), and initializes or updates the state
(\code{state/state.json}) and log (\code{log/log.txt}) files.
}
\examples{
# Example: Build a Grid Statistics Database
\dontrun{
  run_geelite(path = tempdir())
}
# Example: Build a Grid Statistics Database
\dontrun{
  run_geelite(path = tempdir())
}
}
