% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_algo2.R
\name{boot_algo2}
\alias{boot_algo2}
\title{Fast wild cluster bootstrap algorithm}
\usage{
boot_algo2(
  preprocessed_object,
  boot_iter,
  point_estimate,
  impose_null,
  r,
  sign_level,
  param,
  p_val_type,
  nthreads,
  type,
  full_enumeration,
  small_sample_correction,
  conf_int,
  maxiter,
  tol
)
}
\arguments{
\item{preprocessed_object}{A list: output of the preprocess2 function.}

\item{boot_iter}{number of bootstrap iterations}

\item{point_estimate}{The point estimate of the test parameter from the regression model.}

\item{impose_null}{If TRUE, the null is not imposed on the bootstrap distribution.
This is what Roodman et al call the "WCU" bootstrap. With impose_null = FALSE, the
null is imposed ("WCR").}

\item{r}{Shifts the null hypothesis.}

\item{sign_level}{The significance level.}

\item{param}{name of the test parameter.}

\item{p_val_type}{type Type of p-value. By default "two-tailed". Other options: "equal-tailed", ">", "<"}

\item{nthreads}{The number of threads. Can be: a) an integer lower than,
or equal to, the maximum number of threads; b) 0: meaning
all available threads will be used; c) a number strictly
between 0 and 1 which represents the fraction of all threads
to use. The default is to use 50\\% of all threads. You can
set permanently the number of threads used within this
package using the function ...}

\item{type}{character or function. The character string specifies the type
of boostrap to use: One of "rademacher", "mammen", "norm"
and "webb". Alternatively, type can be a function(n) for drawing
wild bootstrap factors. "rademacher" by default.}

\item{full_enumeration}{Is full enumeration employed? Full enum. is used if
N_G^2 < boot_iter for Mammen and Rademacher weights}

\item{small_sample_correction}{The small sample correction to be applied. See ssc().}

\item{conf_int}{Logical. Should confidence intervals be calculated (by test inversion)?}

\item{maxiter}{Integer. Maximum number of iterations used in the root finding procedure to find the confidence interval.
10 by default.}

\item{tol}{Numeric vector of length 1. The desired accuracy
(convergence tolerance) used in the root finding procedure to find the confidence interval.
1e-6 by default.}
}
\value{
A list of ...
}
\description{
function that implements the fast bootstrap algorithm as described in Roodman et al (2019)
}
