% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_Server.R
\name{FG_init_state}
\alias{FG_init_state}
\title{Initialize FG Module State}
\usage{
FG_init_state(FM_yaml_file, MOD_yaml_file, id, id_UD, id_DW, session)
}
\arguments{
\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id}{Shiny module ID}

\item{id_UD}{ID string for the upload data module used to handle uploads or the name of the list element in react_state where the data set is stored.}

\item{id_DW}{ID string for the data wrangling module to process any uploaded data}

\item{session}{Shiny session variable}
}
\value{
list containing an empty app state object
}
\description{
Creates a list of the initialized module state
}
\examples{
# These would be the Shiny input and session variables
input   = list()
session = list()

state = FG_init_state(
   FM_yaml_file  = system.file(package = "formods",
                               "templates",
                               "formods.yaml"),
   MOD_yaml_file = system.file(package = "formods",
                               "templates",
                               "FG.yaml"),
   id              = "FG",
   id_UD           = "UD",
   id_DW           = "DW",
   session         = session)

state
}
