% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{line.plot}
\alias{line.plot}
\title{line.plot}
\usage{
line.plot(
  parent.df,
  category.palette = c("red", "blue"),
  linetype.palette = c("dotted", "blank", "solid", "blank"),
  line.size = 0.75,
  shape.palette = c(24, 21),
  x.label = "Visit",
  y.label = "Response",
  category.label = "Treatment Group",
  x.limits = NULL,
  x.ticks = NULL,
  x.ticks.labels = NULL,
  addBars = TRUE,
  bar.width = 1,
  pdval = 0.25,
  x.col = "XVALUES",
  y.col = "YVALUES",
  y.limits = NULL,
  y.ticks = NULL,
  category.color = "CATEGORY.COLOR",
  category.symbol.col = "CATEGORY.SYMBOL",
  y.digits = 0,
  ymin.col = "YMIN",
  ymax.col = "YMAX",
  linetype.col = "LTYPE"
)
}
\arguments{
\item{parent.df}{data.frame used by ggplot}

\item{category.palette}{colors assoicated with categorical variable}

\item{linetype.palette}{values passed to scale_linetype_manual}

\item{line.size}{value gets passed to size within geom_line, geom_step}

\item{shape.palette}{values passed to scale_shape_manual}

\item{x.label}{value gets passed to labs}

\item{y.label}{value gets passed to labs}

\item{category.label}{passed to x-axis label}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{x.ticks}{value gets passed to scale_x_continuous}

\item{x.ticks.labels}{passed to scale_x_continuous}

\item{addBars}{logical to add error bars (line.plot)}

\item{bar.width}{used by line.plot}

\item{pdval}{value passed to position_dodge (lineplot)}

\item{x.col}{parent.df column associated with response vairable (line.plot, nsubj.plot)}

\item{y.col}{parent.df column associated with response vairable}

\item{y.limits}{passed to scale_y_continuous}

\item{y.ticks}{passed to scale_y_continuous}

\item{category.color}{data.frame column assocated with aes color mapping (forest.plot, line.plot, nsubj.plot, table.plot)}

\item{category.symbol.col}{used by line.plot}

\item{y.digits}{passed to scale_y_continuous label's, fmt (box.plot, line.plot)}

\item{ymin.col}{name of parent.df column associated with ymin (line.plot errorbars)}

\item{ymax.col}{name of parent.df column associated with ymax (line.plot errorbars)}

\item{linetype.col}{name of parent.df column associated with linetype}
}
\value{
A ggplot object is returned.
}
\description{
A function for creating harmonized line plots with optional errorbars.
}
\author{
Greg Cicconetti/David Wade
}
