% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{get_distance_matrix}
\alias{get_distance_matrix}
\title{Computes the distance matrix between a set of shapes.}
\usage{
get_distance_matrix(
  qfuns,
  alignment = FALSE,
  rotation = FALSE,
  scale = FALSE,
  lambda = 0,
  M = 200L,
  parallel_setup = 1L
)
}
\arguments{
\item{qfuns}{A list of functions representing the shapes. Each function
should be a SRVF. See \code{\link[=curve2srvf]{curve2srvf()}} for more details on how to obtain
the SRVF of a shape.}

\item{alignment}{A boolean value specifying whether the two SRVFs should be
optimally aligned before computing the distance. Defaults to \code{FALSE}.}

\item{rotation}{A boolean value specifying whether the two SRVFs should be
optimally rotated before computing the distance. Defaults to \code{FALSE}.}

\item{scale}{A boolean value specifying whether the two SRVFs should be
projected onto the Hilbert sphere before computing the distance. Defaults
to \code{FALSE}.}

\item{lambda}{A numeric value specifying the regularization parameter for the
optimal alignment. Defaults to \code{0}.}

\item{M}{An integer value specifying the number of points to use when
searching for the optimal rotation and alignment. Defaults to \code{200L}.}

\item{parallel_setup}{An integer value specifying the number of cores to use
for parallel computing or an object of class \code{cluster}. In the latter case,
it is used as is for parallel computing. If \code{parallel_setup} is \code{1L}, then
no parallel computing will be used. The maximum number of cores to use is
the number of available cores minus 1. Defaults to \code{1L}.}
}
\value{
An object of class \code{dist} containing the distance matrix between the
shapes.
}
\description{
Computes the distance matrix between a set of shapes.
}
\examples{
N <- 4L
srvfs <- lapply(1:N, \(n) curve2srvf(beta[, , 1, n]))
get_distance_matrix(srvfs, parallel_setup = 1L)
}
