% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-database.R
\name{eyeris_db_collect}
\alias{eyeris_db_collect}
\title{Extract and aggregate eyeris data across subjects from database}
\usage{
eyeris_db_collect(
  bids_dir,
  db_path = "my-project",
  subjects = NULL,
  data_types = NULL,
  sessions = NULL,
  tasks = NULL,
  epoch_labels = NULL,
  eye_suffixes = NULL,
  verbose = TRUE
)
}
\arguments{
\item{bids_dir}{Path to the BIDS directory containing the database}

\item{db_path}{Database name (defaults to "my-project", becomes "my-project.eyerisdb")}

\item{subjects}{Vector of subject IDs to include. If NULL (default), includes all subjects}

\item{data_types}{Vector of data types to extract. If NULL (default), extracts all available types.
Valid types: "blinks", "events", "timeseries", "epochs", "epoch_summary",
"run_confounds", "confounds_events", "confounds_summary"}

\item{sessions}{Vector of session IDs to include. If NULL (default), includes all sessions}

\item{tasks}{Vector of task names to include. If NULL (default), includes all tasks}

\item{epoch_labels}{Vector of epoch labels to include. If NULL (default), includes all epochs.
Only applies to epoch-related data types}

\item{eye_suffixes}{Vector of eye suffixes to include. If NULL (default), includes all eyes.
Typically c("eye-L", "eye-R") for binocular data}

\item{verbose}{Logical. Whether to print progress messages (default TRUE)}
}
\value{
A named list of data frames, one per data type
}
\description{
A comprehensive wrapper function that simplifies extracting \code{eyeris} data from
the database. Provides easy one-liner access to aggregate data across multiple
subjects for each data type, without requiring SQL knowledge.
}
\examples{
\donttest{
demo_data <- eyelink_asc_demo_dataset()

demo_data |>
eyeris::glassbox() |>
eyeris::epoch(
  events = "PROBE_{startstop}_{trial}",
  limits = c(-1, 1),
  label = "prePostProbe"
) |>
eyeris::bidsify(
  bids_dir = tempdir(),
  participant_id = "001",
  session_num = "01",
  task_name = "assocret",
  run_num = "03", # override default run-01 (block_1) to use run-03 instead
  db_enabled = TRUE # enable database storage
)

# extract all data for all subjects (returns list of data frames)
all_data <- eyeris_db_collect(tempdir())

# view available data types
names(all_data)

# access specific data type
blinks_data <- all_data$blinks
epochs_data <- all_data$epochs

# extract specific subjects and data types
subset_data <- eyeris_db_collect(
  bids_dir = tempdir(),
  subjects = c("001"),
  data_types = c("blinks", "epochs", "timeseries")
)

# extract epoch data for specific epoch label
epoch_data <- eyeris_db_collect(
  bids_dir = tempdir(),
  data_types = "epochs",
  epoch_labels = "prepostprobe"
)

}

}
