% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd.R
\name{eGFR_adult_SCysC}
\alias{eGFR_adult_SCysC}
\alias{eGFR_adult_SCysC.data.frame}
\alias{eGFR_adult_SCysC.units}
\alias{eGFR_adult_SCysC.numeric}
\title{eGFR 2012 CKD-EPI cystatin C equation}
\usage{
eGFR_adult_SCysC(...)

\method{eGFR_adult_SCysC}{data.frame}(.data, SCysC, Age, male, ...)

\method{eGFR_adult_SCysC}{units}(SCysC, Age, male, ...)

\method{eGFR_adult_SCysC}{numeric}(SCysC, Age, male, ...)
}
\arguments{
\item{...}{Further optional arguments}

\item{.data}{(data.frame) A data.frame, optional}

\item{SCysC}{Serum Cystatin C
column name, or vector of units or numeric if \code{.data} is not provided}

\item{Age}{Age of patient
column name, or vector of units or numeric if \code{.data} is not provided}

\item{male}{Male or not
column name, or vector of logical (TRUE/FALSE) if \code{.data} is not provided}
}
\value{
Estimated GFR
of the same type provided (numeric or units)
}
\description{
Using KDIGO 2012 Clinical Practice Guideline for
the Evaluation and Management of Chronic Kidney Disease
Volume 3 | Issue 1 | January 2013
}
\details{
See \url{https://kdigo.org/guidelines/ckd-evaluation-and-management/} for more details
}
\examples{
eGFR_adult_SCysC(eGFR_pt_data,
  SCysC = "SCysC_", Age = "Age_", male = "male_"
)

eGFR_pt_data \%>\%
  dplyr::mutate(eGFR = eGFR_adult_SCysC(
    SCysC = SCysC_, Age = Age_, male = male_
  ))
}
