% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateNests.R
\name{UpdateNests}
\alias{UpdateNests}
\title{Create a dataset of class Nests2 from an object of class Nests}
\usage{
UpdateNests(
  data = stop("An object with nests must be provided !"),
  weight = NULL,
  LayingTime = NULL,
  UnitTime = NULL,
  Longitude = NULL,
  Latitude = NULL,
  Informations = NULL,
  Males = NULL,
  Females = NULL,
  hatchling.metric.mean = NULL,
  hatchling.metric.sd = NULL
)
}
\arguments{
\item{data}{An object of class Nests or Nests2.}

\item{weight}{The weight of different nests for likelihood estimation.}

\item{LayingTime}{Named POSIXct or POSIXlt time for each nest in data.}

\item{UnitTime}{The units for time as a named list or vector}

\item{Longitude}{The longitude of the nests as a named list or vector}

\item{Latitude}{The latitude of the nests as a named list or vector}

\item{Informations}{Some textual information about the nests as a named list or vector}

\item{Males}{Number of sexed eggs being males.}

\item{Females}{Number of sexed eggs being females.}

\item{hatchling.metric.mean}{The average size of hatchlings.}

\item{hatchling.metric.sd}{The standard deviation of size of hatchlings.}
}
\value{
A list with all the nests formated to be used with searchR.
}
\description{
Will create a dataset of class Nests2 to be used with searchR\cr
This function is used to convert Nests or Nests2 format into the new one, Nests2, and add information.\cr
}
\details{
UpdateNests creates a dataset of class "Nests2" to be used with searchR
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
nest <- FormatNests(nest)
nest2 <- UpdateNests(data=nest)
nest2 <- UpdateNests(data=nest2, Males=c(DY.1=10), Females=c(DY.1=20))
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
