# Generated by 02-duckplyr_df-methods.R
#' @export
group_trim.duckplyr_df <- function(.tbl, .drop = group_by_drop_default(.tbl)) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "No relational implementation for {.code group_trim()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.tbl, duckplyr_error)

  group_trim <- dplyr$group_trim.data.frame
  out <- group_trim(.tbl, .drop)
  return(out)

  # dplyr implementation
  .tbl
}

duckplyr_group_trim <- function(.tbl, ...) {
  try_fetch(
    .tbl <- as_duckplyr_df_impl(.tbl),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_trim(.tbl, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
