% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{getBootstraps}
\alias{getBootstraps}
\title{Creates a bootstrap distribution for clone sequence alignments, and returns  
estimated trees for each bootstrap replicate as a nested list as a new input 
tibble column.}
\usage{
getBootstraps(
  clones,
  bootstraps,
  nproc = 1,
  bootstrap_nodes = TRUE,
  dir = NULL,
  id = NULL,
  build = "pratchet",
  exec = NULL,
  quiet = 0,
  rm_temp = TRUE,
  rep = NULL,
  seq = NULL,
  boot_part = "locus",
  by_codon = TRUE,
  starting_tree = FALSE,
  switches = FALSE,
  ...
)
}
\arguments{
\item{clones}{tibble \code{airrClone} objects, the output of 
\link{formatClones}}

\item{bootstraps}{number of bootstrap replicates to perform}

\item{nproc}{number of cores to parallelize computations}

\item{bootstrap_nodes}{a logical if the the nodes for each tree in the trees
column (required) should report their bootstrap value}

\item{dir}{directory where temporary files will be placed (required
if \code{igphyml} or \code{dnapars} specified)}

\item{id}{unique identifer for this analysis (required if 
\code{igphyml} or \code{dnapars} specified)}

\item{build}{program to use for tree building (phangorn, dnapars, igphyml)}

\item{exec}{location of desired phylogenetic executable}

\item{quiet}{amount of rubbish to print to console}

\item{rm_temp}{remove temporary files (default=TRUE)}

\item{rep}{current bootstrap replicate (experimental)}

\item{seq}{column name containing sequence information}

\item{boot_part}{is  "locus" bootstrap columns for each locus separately}

\item{by_codon}{a logical if the user wants to bootstrap by codon or by 
nucleotide. Default (codon based bootstrapping) is TRUE.}

\item{starting_tree}{An indicator to use the existing trees column as the starting trees for RAxML}

\item{switches}{a logical indicator to allow findSwitches to do permutations.}

\item{...}{additional arguments to be passed to tree building program}
}
\value{
The input clones tibble with an additional column for the bootstrap replicate trees.
}
\description{
\code{getBootstraps} Phylogenetic bootstrap function.
}
