% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_unit.R
\name{var_unit}
\alias{var_unit}
\alias{var_unit<-}
\alias{get_variable_units}
\alias{unit_attribute}
\alias{get_unit_attribute}
\alias{set_unit_attribute}
\alias{unit_attribute<-}
\title{Get / Set a unit of measure}
\usage{
var_unit(x, ...)

var_unit(x) <- value

get_variable_units(x, ...)

unit_attribute(x)

get_unit_attribute(x)

set_unit_attribute(x, value)

unit_attribute(x) <- value
}
\arguments{
\item{x}{A vector.}

\item{...}{Further potential parameters reserved for inherited classes.}

\item{value}{A character string or \code{NULL} to remove the unit of measure.}
}
\value{
The unit attribute of a vector constructed with \code{\link{defined}},
or any vector that is enriched with a unit attribute. \cr
\cr
The \code{var_unit<-}
assignment method allows to add, remove, or overwrite this attribute on a vector
\code{x}. The assignment function returns the \code{x} vector invisibly.
}
\description{
Get / Set a unit of measure
}
\details{
The aim of the \code{unit} attribute is to add to the R vector object its
unit of measure (for example, physical units like gram and kilogram or
currency units like dollars or euros), so that they are not concatenated or
joined in a syntactically correct but semantically incorrect way (i.e.,
accidentally concatenating values quoted in dollars and euros from different
subvectors.) This is particularly useful when working with linked open data,
i.e., when joins or concatenations are performed on data arriving from a remote
source.\cr \cr
\code{get_variable_units()} is identical to \code{var_unit()}.
\cr
\cr
See \code{vignette("defined", package = "dataset")} to use comprehensively
with variable labels, namespaces, units of measures, and machine-independent
permanent variable identifiers.
}
\examples{
# The defined vector class and dataset_df support units of measure attributes:
var_unit(orange_df$circumference)

# Normally columns of a data.frame do not have a unit attribute:
var_unit(mtcars$wt)

# You can add them with the assignment function:
var_unit(mtcars$wt) <- "1000 lbs"

# To remove a unit of measure assign the NULL value:
var_unit(mtcars$wt) <- NULL
}
\seealso{
Other defined metadata methods and functions: 
\code{\link{defined}()},
\code{\link{var_label}()},
\code{\link{var_namespace}()}
}
\concept{defined metadata methods and functions}
