% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryMethods.R
\name{summary.dataRobotModel}
\alias{summary.dataRobotModel}
\alias{summary.dataRobotProject}
\alias{summary.listOfBlueprints}
\alias{summary.listOfFeaturelists}
\alias{summary.listOfModels}
\alias{summary.projectSummaryList}
\title{DataRobot S3 object methods for R's generic summary function}
\usage{
\method{summary}{dataRobotModel}(object, ...)

\method{summary}{dataRobotProject}(object, ...)

\method{summary}{listOfBlueprints}(object, nList = 6, ...)

\method{summary}{listOfFeaturelists}(object, nList = 6, ...)

\method{summary}{listOfModels}(object, nList = 6, ...)

\method{summary}{projectSummaryList}(object, nList = 6, ...)
}
\arguments{
\item{object}{The S3 object to be summarized.}

\item{\dots}{list. Not currently used.}

\item{nList}{integer. For the 'listOf' class objects, the first
nList elements of the list are summarized in the dataframe in
the second element of the list returned by the function.}
}
\value{
An object-specific summary: for objects of class
  dataRobotModel and dataRobotProject, this summary is a
  character vector giving key characteristics of the model or
  project, respectively; for the other object classes, the
  value is a two-element list where the first element is a
  brief summary character string and the second element
  is a more detailed dataframe with nList elements.
  The summary of object has the following components:
  modelType, expandedModel (constructed from modelType and processes),
  modelId, blueprintId, and projectId.
}
\description{
These functions extend R's generic summary function to the
DataRobot S3 object classes dataRobotModel, dataRobotProject,
listOfBlueprints, listOfFeaturelists, listOfModels, and
projectSummaryList.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  summary(model)
}
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  project <- GetProject(projectId)
  summary(project)
}
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  blueprints <- ListBlueprints(projectId)
  summary(blueprints)
}
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  featureList <- CreateFeaturelist(projectId, "myFeaturelist", c("feature1", "feature2"))
  summary(featureList)
}
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  models <- ListModels(projectId)
  summary(models)
}
\dontrun{
  projectSummary <- ListProjects()
  summary(projectSummary)
}
}
