% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeploymentAccuracy.R
\name{GetDeploymentAccuracy}
\alias{GetDeploymentAccuracy}
\title{Retrieve accuracy statistics for a deployment.}
\usage{
GetDeploymentAccuracy(
  deploymentId,
  modelId = NULL,
  start = NULL,
  end = NULL,
  segmentAttribute = NULL,
  segmentValue = NULL,
  targetClasses = NULL
)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}

\item{modelId}{character. Optional. The ID of the model to query. If provided, only data for this
specific model will be retrieved; otherwise, data for the deployment's default model will be
retrieved.}

\item{start}{POSIXct. Optional. The start time of the reporting period for monitoring data.
Defaults to seven days prior to the end of the period. Sub-hour resolution is not permitted,
and the timezone must be \code{UTC}.}

\item{end}{POSIXct. Optional. The end time of the reporting period for monitoring data. Defaults
to the next top of the hour. Sub-hour resolution is not permitted, and the timezone must be
\code{UTC}.}

\item{segmentAttribute}{character. Optional. The name of an attribute used for segment analysis.
See \code{SegmentAnalysisAttribute} for permitted values. Added in DataRobot 2.21.}

\item{segmentValue}{character. Optional. The value of \code{segmentAttribute}. Added in DataRobot
2.21.}

\item{targetClasses}{character. Optional. List of target classes to filter out of the response.
Added in DataRobot 2.23.}
}
\value{
An object representing service health metrics for the deployment, containing:
\itemize{
\item modelId character. The ID of the deployment model for which monitoring data was
retrieved.
\item period list. The duration of the reporting period, containing:
\itemize{
\item start POSIXct. Start of the reporting period.
\item end POSIXct. End of the reporting period.
}
\item metrics data.frame. Accuracy metrics for the deployment, where each row is a separate
metric and contains the columns:
\itemize{
\item metric. character. Name of the metric. See \code{DeploymentAccuracyMetric} for valid
values.
\item baselineValue. numeric. May be NA if accuracy data is not available.
\item value. numeric. May be NA if accuracy data is not available.
\item percentChange. numeric. The percent change of value over baseline. May be NA if
accuracy data is not available.
}
\item segmentAttribute character. Optional. The name of the segment on which segment analysis
was performed. Added in DataRobot 2.21.
\item segmentValue character. Optional. The value of the segmentAttribute. Added in DataRobot
2.21.
}
}
\description{
Retrieve accuracy statistics for a deployment.
}
\examples{
\dontrun{
library(dplyr)
deploymentId <- "59a5af20c80891534e3c2bde"
acc <- GetDeploymentAccuracy(deploymentId, end = ISOdate(2021, 01, 06, 1, 0, 0, tz = "UTC"))
df <- mutate(
       acc$metrics,
       "modelId" = acc$modelId,
       "startTime" = acc$period$start,
       "endTime" = acc$period$end,
       .before = everything()
   )
}
}
\seealso{
Other deployment accuracy functions: 
\code{\link{GetDeploymentAccuracyOverTime}()},
\code{\link{GetDeploymentAssociationId}()},
\code{\link{SubmitActuals}()}
}
\concept{deployment accuracy functions}
