% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{createD1Object}
\alias{createD1Object}
\alias{createD1Object,D1Client,D1Object-method}
\title{Create the Object in the DataONE System}
\usage{
createD1Object(x, d1Object, ...)

\S4method{createD1Object}{D1Client,D1Object}(x, d1Object)
}
\arguments{
\item{x}{: D1Client}

\item{d1Object}{A D1Object instance to upload to DataONE}

\item{...}{(not yet used)}
}
\value{
TRUE if the object was successfully uploaded, FALSE if not.
}
\description{
Create the Object in the DataONE System
}
\examples{
\dontrun{
library(dataone)
library(uuid)
d1c <- D1Client("STAGING", "urn:node:mnStageUCSB2")
data <- readLines(system.file("extdata/strix-pacific-northwest.xml", package="dataone"))
dataRaw <- charToRaw(paste(data, collapse="\\n"))
newid <- sprintf("urn:node:\%s", UUIDgenerate())
d1o <- new("D1Object", id=newid, data=dataRaw, format="text/plain")
d1o <- setPublicAccess(d1o)
# Upload the object to DataONE (requires authentication)
uploaded <- createD1Object(d1c, d1o)
}
}
