% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric_manipulations.R
\name{find_and_transform_numerics}
\alias{find_and_transform_numerics}
\title{Identify numeric columns in a data_set set}
\usage{
find_and_transform_numerics(
  data_set,
  cols = "auto",
  n_test = 30,
  verbose = TRUE
)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of data_set to look into. To check all all columns, set it
to "auto". (characters, default to "auto")}

\item{n_test}{Number of non-null rows on which to test (numeric, default to 30)}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\value{
The data_set set (as a data.table) with identified numeric transformed.
}
\description{
Function to find and transform characters that are in fact numeric.
}
\details{
This function is looking for perfect transformation.
If there are some mistakes in data_set, consider setting them to NA before. \cr
If there are some columns that have no chance to be a match think of removing them from \code{cols}
to save some computation time.
}
\section{Warning}{

All these changes will happen \strong{by reference}.
}

\examples{
# Let's build a data_set set
data_set <- data.frame(ID = seq_len(5),
                  col1 = c("1.2", "1.3", "1.2", "1", "6"),
                  col2 = c("1,2", "1,3", "1,2", "1", "6")
                  )

# using the find_and_transform_numerics
find_and_transform_numerics(data_set, n_test = 5)
}
